/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.ConditionFormat;
import com.bmc.ctmconvert.uc4.PreRecWalker;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectProcessFlow;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;

public class OutConditionsGenerator {
    private final ConditionFormat conditionFormat;
    private final UC4Job uc4Job;
    private final UC4Object jobObject;

    public OutConditionsGenerator(UC4Job uc4Job, ConditionFormat conditionFormat) {
        this.uc4Job = uc4Job;
        this.conditionFormat = conditionFormat;
        this.jobObject = uc4Job.getObj();
    }

    public List<Properties> getOutCond() {
        ArrayList<Properties> outconds = new ArrayList<Properties>();
        if (this.isExternalDependencies()) {
            outconds.addAll(this.getExternalDependency());
        }
        HashSet condNames = new HashSet();
        BiConsumer<IAttrHolder, UC4ObjectProcessFlow> outConditionCreatorConsumer = (preRec, processFlow) -> {
            String condName = this.conditionFormat.buildConditionName((UC4ObjectProcessFlow)processFlow, (IAttrHolder)preRec);
            if (this.isEndedOk(preRec.getAttr("pre_When"))) {
                this.createOutCondRegular(outconds, condNames, condName);
            }
        };
        PreRecWalker walker = new PreRecWalker(this.uc4Job);
        walker.forEachPreRec(outConditionCreatorConsumer);
        return outconds;
    }

    private String uniqueCondName(String condName) {
        String format = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
        if (format.contains("{TO_JOB}")) {
            condName = this.uc4Job.getOutConds(condName);
        }
        return condName;
    }

    private boolean isExternalDependencies() {
        return this.uc4Job.getObj().isExternalDependences();
    }

    private Set<Properties> getExternalDependency() {
        HashSet<Properties> outconds = new HashSet<Properties>();
        String format = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
        if (format.contains("{TO_JOB}")) {
            for (UC4Object uc4Object : this.jobObject.getExternalJobs()) {
                outconds.add(this.getOutCondForXTRNL(uc4Object.getName()));
            }
        } else {
            outconds.add(this.getOutCondForXTRNL("ENDED_OK"));
            outconds.add(this.getOutCondForXTRNL(""));
        }
        return outconds;
    }

    private Properties getOutCondForXTRNL(String pre_When) {
        String condName = this.conditionFormat.buildConditionNameForOutExternalDependency(this.uc4Job.getOriginalJobName(), pre_When);
        return Globs.makeOutCond((String)this.uniqueCondName(condName), (String)"ODAT", (String)"ADD");
    }

    private boolean isEndedOk(String pre_When) {
        return pre_When.equalsIgnoreCase("ANY_OK") || pre_When.equalsIgnoreCase("ENDED_OK_OR_INACTIV") || pre_When.equalsIgnoreCase("ENDED_OK") || pre_When.equalsIgnoreCase("");
    }

    private void createOutCondRegular(List<Properties> outconds, Set<String> condNames, String condName) {
        if (!condNames.contains(condName = this.uniqueCondName(condName))) {
            outconds.add(Globs.makeOutCond((String)condName, (String)"ODAT", (String)"ADD"));
            condNames.add(condName);
        }
    }
}

