/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.uc4.ConditionFormat;
import com.bmc.ctmconvert.uc4.PreRecWalker;
import com.bmc.ctmconvert.uc4.UC4Defs;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectProcessFlow;
import java.util.ArrayList;
import java.util.Properties;
import java.util.function.BiConsumer;

public class OutCondForOnStmt {
    private UC4Job uc4Job;
    private ConditionFormat conditionFormat;

    public OutCondForOnStmt(UC4Job uc4Job, ConditionFormat conditionFormat) {
        this.uc4Job = uc4Job;
        this.conditionFormat = conditionFormat;
    }

    public void getOutCondForOnStmt(final RulesDataSet rules, final UC4Defs sourceDefinitions) {
        PreRecWalker walker = new PreRecWalker(this.uc4Job);
        BiConsumer<IAttrHolder, UC4ObjectProcessFlow> onDoCreatorConsumer = new BiConsumer<IAttrHolder, UC4ObjectProcessFlow>(){

            @Override
            public void accept(IAttrHolder preRec, UC4ObjectProcessFlow processFlow) {
                String condName = OutCondForOnStmt.this.conditionFormat.buildConditionName(processFlow, preRec);
                String pre_When = preRec.getAttr("pre_When");
                boolean endedNotOk = OutCondForOnStmt.this.isEndedNotOk(pre_When);
                if (endedNotOk) {
                    OutCondForOnStmt.this.createOutCondForOnStmt(condName, pre_When, rules, sourceDefinitions);
                }
            }
        };
        walker.forEachPreRec(onDoCreatorConsumer);
    }

    private boolean isEndedNotOk(String pre_When) {
        if (this.uc4Job.isStartJob()) {
            return false;
        }
        return !pre_When.equalsIgnoreCase("ANY_OK") && !pre_When.equalsIgnoreCase("ENDED_OK") && !pre_When.equalsIgnoreCase("ENDED_OK_OR_INACTIV") && !pre_When.equalsIgnoreCase("");
    }

    private void createOutCondForOnStmt(String condName, String pre_When, RulesDataSet rules, UC4Defs sourceDefinitions) {
        condName = this.uniqueCondName(rules, sourceDefinitions, condName);
        Properties tmpOnStatement = new Properties();
        Properties tmpDoStatement = new Properties();
        if (pre_When.equalsIgnoreCase("ENDED_NOT_OK")) {
            tmpOnStatement.setProperty("CODE", "NOTOK");
        } else {
            if (this.uc4Job.type().equals((Object)SchedEntity.TYPE.JOB)) {
                tmpOnStatement.setProperty("CODE", String.format("CONVERTED %s", pre_When));
            } else {
                tmpOnStatement.setProperty("CODE", "OK");
            }
            Reporter.addMessage(this.uc4Job.getMessages(), (String)"INF8001", (String)this.uc4Job.generateUniqueID(), (String[])new String[]{pre_When, tmpOnStatement.getProperty("CODE")});
        }
        if (this.uc4Job.isDSJob()) {
            tmpOnStatement.setProperty("STMT", "*");
        } else {
            tmpOnStatement.setProperty("PGMS", "ANYSTEP");
            tmpOnStatement.setProperty("PROCS", "ANYSTEP");
        }
        tmpDoStatement.setProperty("ACTION", "DOCOND");
        tmpDoStatement.put("NAME", condName);
        tmpDoStatement.setProperty("ODATE", "ODAT");
        tmpDoStatement.put("SIGN", "ADD");
        ArrayList<Properties> tmpDoStatementList = new ArrayList<Properties>();
        tmpDoStatementList.add(tmpDoStatement);
        this.uc4Job.addOnDoStmt(tmpOnStatement, tmpDoStatementList);
    }

    private String uniqueCondName(RulesDataSet rules, UC4Defs sourceDefinitions, String condName) {
        String format = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
        if (format.contains("{TO_JOB}")) {
            condName = this.uc4Job.getOutConds(condName);
        }
        return condName;
    }
}

