/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.CmConvertor;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.vc.FieldValidation;

public class OS400Convertor
implements CmConvertor {
    private final RealConvertor convertor;

    public OS400Convertor(UC4Job uc4Job) {
        this.convertor = new RealConvertor(uc4Job);
    }

    @Override
    public void convertToCm(UC4Job uc4Job) {
        this.convertor.setJobname();
        this.convertor.addOs400Attributes();
        this.convertor.addOs400Variables();
        this.convertor.cleanAttributes();
        this.addUnsupportedMessage(uc4Job);
    }

    @Override
    public String getConvertJobName(UC4Job uc4Job) {
        return this.convertor.getOs400JobName();
    }

    private void addUnsupportedMessage(UC4Job uc4Job) {
        XmlElement element = uc4Job.getJobXmlElement();
        if (element != null && element.getAttribute("Com").equals("0")) {
            OS400Convertor.addMessage(uc4Job, "WRN8039");
        }
    }

    private static void addMessage(UC4Job uc4Job, String message) {
        String originalJobName = uc4Job.getOriginalJobName();
        String jobName = uc4Job.getJobName();
        uc4Job.addMessage(message, originalJobName, jobName);
    }

    public static boolean isOs400Type(String hostType) {
        return hostType != null && hostType.equals("OS400");
    }

    private String replaceIllegalValidationCharacter(String jobName) {
        String validationCharacter = "_";
        return jobName.replaceAll(validationCharacter, "#");
    }

    private boolean isVariableFormat(String jobname) {
        return jobname.startsWith("&") && jobname.endsWith("#");
    }

    private class RealConvertor {
        private final UC4Job uc4Job;
        private final XmlElement element;

        public void addOs400Attributes() {
            this.uc4Job.addAttribute("APPL_TYPE", "OS400");
            this.uc4Job.addAttribute("APPL_VER", "7.0.01");
            this.uc4Job.addAttribute("APPL_FORM", "OS/400 Full");
            this.uc4Job.addAttribute("CM_VER", "N/A");
            this.uc4Job.addAttribute("TASKTYPE", "Job");
        }

        public void addOs400Variables() {
            this.uc4Job.addVariable("%%OS400-AEV_LEN", "4000");
            this.setJobqueue();
            String login = "controlm";
            this.uc4Job.addVariable("%%OS400-JOB_OWNER", login);
            this.uc4Job.addVariable("%%OS400-OBJTYP", "*MULTICMD");
            this.addOS400MultipleCommands();
        }

        private void setJobqueue() {
            String jobQueue;
            if (this.element != null && (jobQueue = this.element.getFirstChildValue("JobQueue")) != null) {
                this.uc4Job.addVariable("%%OS400-JOBQ", OS400Convertor.this.replaceIllegalValidationCharacter(jobQueue.trim()));
            }
        }

        private void addOS400MultipleCommands() {
            String[] lines = this.uc4Job.getObj().getAttribute("MSCRI").split("\n");
            int i = 1;
            boolean isCmdWithScript = false;
            for (String line : lines) {
                if (!this.isNotEmptyLine(line)) continue;
                this.uc4Job.addVariable(String.format("%%%%OS400-CMDLINE%s", i++), line);
                if (isCmdWithScript || !line.startsWith(":")) continue;
                isCmdWithScript = true;
            }
            if (isCmdWithScript) {
                OS400Convertor.addMessage(this.uc4Job, "WRN8068");
            }
        }

        public RealConvertor(UC4Job uc4Job) {
            this.uc4Job = uc4Job;
            this.element = uc4Job.getJobXmlElement();
        }

        public void setJobname() {
            String jobname = this.getOs400JobName();
            this.uc4Job.addVariable("%%OS400-JOB_NAME", jobname.replaceAll("_", "#"));
            this.uc4Job.setName(jobname);
        }

        private String getOs400JobName() {
            String jobname = "";
            if (this.element != null && ((jobname = this.element.getFirstChildValue("JobName")).isEmpty() || OS400Convertor.this.isVariableFormat(jobname))) {
                jobname = this.element.getAttribute("name");
            }
            jobname = FieldValidation.instance().validateAndReturnFixedValue("OS400JOBNAME", jobname.trim());
            return OS400Convertor.this.replaceIllegalValidationCharacter(jobname);
        }

        public void cleanAttributes() {
            this.uc4Job.addAttribute("MEMNAME", "");
        }

        private boolean isNotEmptyLine(String line) {
            return line != null && !line.isEmpty() && !line.startsWith("!");
        }
    }
}

