/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.uc4.ConditionFormat;
import com.bmc.ctmconvert.uc4.UC4Defs;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectProcessFlow;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class InConditionsGenerator {
    static final String PRE_PRE_LNR = "pre_PreLnr";
    UC4Job uc4Job;
    ConditionFormat conditionFormat;

    public InConditionsGenerator(UC4Job uc4Job, ConditionFormat conditionFormat) {
        this.uc4Job = uc4Job;
        this.conditionFormat = conditionFormat;
    }

    public List<Properties> generateInConds(UC4Defs sourceDefinitions) {
        String taskLnr;
        String taskIdnr;
        ArrayList<Properties> inconds = new ArrayList<Properties>();
        String and_or = "OR";
        if (this.uc4Job.getParent() == null || !this.uc4Job.getParent().getObj().getType().equals((Object)UC4Globals.UC4_TYPES.JOBP)) {
            return inconds;
        }
        UC4ObjectProcessFlow processFlow = (UC4ObjectProcessFlow)this.uc4Job.getParent().getObj();
        AttrHolderList jobPreds = processFlow.getJobPredAttributesByJob(taskIdnr = this.uc4Job.getUc4TaskAttr().getAttr("task_Idnr"), taskLnr = this.uc4Job.getUc4TaskAttr().getAttr("task_Lnr"));
        if (jobPreds == null) {
            return inconds;
        }
        String WCTypeAND = this.uc4Job.getUc4TaskAttr().getAttr("when_WCTypeAND");
        if (WCTypeAND != null && WCTypeAND.equals("1")) {
            and_or = "AND";
        }
        HashSet<String> condNames = new HashSet<String>();
        for (IAttrHolder preRec : jobPreds) {
            String pre_object_type;
            String pre_object_name = processFlow.getTaskObjectByLnr(preRec.getAttr(PRE_PRE_LNR));
            if (this.doesStartTaskConditionsIncluded(pre_object_name)) continue;
            String condName = this.conditionFormat.buildConditionName(processFlow, preRec);
            String format = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
            if (format.contains("{TO_JOB}")) {
                condName = sourceDefinitions.getUniqueInConditionName(condName);
            }
            if ((pre_object_type = processFlow.getTaskObjectTypeByLnr(preRec.getAttr(PRE_PRE_LNR))) != null && pre_object_type.equalsIgnoreCase("<XTRNL>")) {
                condName = this.getPredEntityXTRNL(processFlow, preRec, pre_object_name);
            }
            if (condNames.contains(condName)) continue;
            inconds.add(Globs.makeInCond((String)condName, (String)"ODAT", (String)and_or));
            condNames.add(condName);
        }
        return inconds;
    }

    private String getPredEntityXTRNL(UC4ObjectProcessFlow processFlow, IAttrHolder preRec, String pre_object_name) {
        IAttrHolder taskRec = processFlow.getPreRecByLnr(preRec.getAttr(PRE_PRE_LNR));
        String condName = "";
        if (taskRec.getAttr("cale").equals("YES")) {
            Reporter.addMessage(this.uc4Job.getMessages(), (String)"WRN8023", (String)this.uc4Job.generateUniqueID(), (String[])new String[]{taskRec.getAttr("root")});
        }
        condName = this.conditionFormat.buildConditionNameForInExternalDependency(processFlow, preRec);
        if (this.uc4Job.getSourceDefinitions().getObjById(pre_object_name) == null) {
            Reporter.addMessage(this.uc4Job.getMessages(), (String)"WRN8004", (String)this.uc4Job.generateUniqueID(), (String[])new String[]{pre_object_name, condName});
        }
        return condName;
    }

    private boolean doesStartTaskConditionsIncluded(String pre_object_name) {
        return pre_object_name != null && pre_object_name.toLowerCase().equals("start") && !this.uc4Job.getConvertStartEND();
    }
}

