/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.uc4.DbEventHandler;
import com.bmc.ctmconvert.uc4.FileEventHandler;
import com.bmc.ctmconvert.uc4.TimeEventHandler;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.TriggeredJobsHandler;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import java.util.List;
import java.util.Set;

public class EventObjectManager {
    private final UC4Object obj;
    private final UC4Job uc4Job;
    private final TriggeredJobsHandler triggeredJobsHandler;

    public EventObjectManager(UC4Object obj, UC4Job uc4Job) {
        this.obj = obj;
        this.uc4Job = uc4Job;
        this.triggeredJobsHandler = uc4Job.getUC4ObjectTablesMap().getTriggeredJobsHandler();
    }

    public void handleEventObject() {
        if (this.obj.getFullType().equalsIgnoreCase(UC4Globals.SUPPORTED_JOBS_TYPES.EVNT_FILE.toString())) {
            FileEventHandler fileEventHandler = new FileEventHandler(this.obj, this.uc4Job);
            if (!this.uc4Job.getObj().getType().equals((Object)UC4Globals.UC4_TYPES.EVNT)) {
                AssistingJob tmpJob = new AssistingJob((SchedEntity)this.uc4Job);
                fileEventHandler.createFileWatcherJob((SchedEntity)tmpJob);
                this.uc4Job.addAssistingJob(tmpJob);
            } else {
                fileEventHandler.createFileWatcherJob(this.uc4Job);
            }
        } else if (this.obj.getFullType().equalsIgnoreCase(UC4Globals.SUPPORTED_JOBS_TYPES.EVNT_TIME.toString())) {
            TimeEventHandler timeEventHandler = new TimeEventHandler(this.obj, this.uc4Job);
            timeEventHandler.handleTimeEvent();
            this.handleMessageForMissingTriggeredObject();
            this.handleMessageforJOBPObject();
        } else if (this.uc4Job.isDbEvent()) {
            new DbEventHandler(this.obj, this.uc4Job).handleEvent();
            this.handleMessageForMissingTriggeredObject();
            this.handleMessageforJOBPObject();
        } else {
            this.uc4Job.addMessage("WRN8014", this.uc4Job.generateUniqueID(), this.obj.getFullType(), this.uc4Job.getOriginalJobName(), this.uc4Job.getJobName());
            this.uc4Job.addAttribute("TASKTYPE", "Dummy");
        }
        this.addMessagesToEvent(this.obj.getName());
    }

    private void addMessagesToEvent(String eventName) {
        Set<NewMessage> messagesList = this.triggeredJobsHandler.getMessagesForEvent(eventName);
        if (messagesList != null) {
            for (NewMessage msg : messagesList) {
                this.uc4Job.addMessage(msg.getMessageId(), this.obj.getName(), this.uc4Job.getJobName(), msg.getMessageParams().toString());
            }
        }
    }

    private void handleMessageforJOBPObject() {
        if (this.uc4Job.getObj().getType().equals((Object)UC4Globals.UC4_TYPES.JOBP)) {
            this.uc4Job.addMessage("WRN8057", this.obj.getName(), this.uc4Job.getJobName());
        }
    }

    private void handleMessageForMissingTriggeredObject() {
        List<String> missingList = this.triggeredJobsHandler.getEventNameToMisingObjectsNamesMapByEventName(this.uc4Job.getOriginalJobName());
        if (missingList != null) {
            String[] args = new String[]{this.uc4Job.getOriginalJobName(), missingList.toString(), this.uc4Job.getJobName()};
            this.uc4Job.addMessage("WRN8056", args);
        }
    }
}

