/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.ondo.Capture;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.uc4.SQLJobConvertor;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;

public class DbEventHandler {
    private final UC4Job uc4Job;
    private final UC4Object obj;

    public DbEventHandler(UC4Object obj, UC4Job uc4Job) {
        this.obj = obj;
        this.uc4Job = uc4Job;
    }

    public void handleEvent() {
        new SQLJobConvertor().convertToCm(this.uc4Job, this.obj.getAttribute("Op1_sql"));
        this.setCyclicAttributes();
        String dbAccountName = UC4ConnectionsHelper.getValidatedConnectionProfileName(this.obj.getAttribute("Op1_host") + "_" + this.obj.getAttribute("Op1_db"));
        this.uc4Job.addAutoEdits("%%DB-ACCOUNT", dbAccountName);
        this.addAction(dbAccountName);
    }

    private void setCyclicAttributes() {
        this.uc4Job.addAttribute("CYCLIC", "1");
        this.uc4Job.addAttribute("CYCLIC_TYPE", "Interval");
        int interval = Integer.parseInt(this.obj.getAttribute("TimePeriodTT"));
        this.uc4Job.addAttribute("INTERVAL", String.format("%05dM", interval));
        this.uc4Job.addAttribute("IND_CYCLIC", "START");
        String uc4Operator = this.obj.getAttribute("Operator");
        String operator = "";
        if (uc4Operator.startsWith("E|")) {
            operator = "EQ";
        }
        if (uc4Operator.startsWith("G|")) {
            operator = "GT";
        }
        if (uc4Operator.startsWith("N|")) {
            operator = "NE";
        }
        if (uc4Operator.startsWith("L|")) {
            operator = "LE";
        }
        this.uc4Job.addOnDoStmt(new StopCyclic(operator, this.obj.getAttribute("Op2_static")));
        this.uc4Job.addCapture(new Capture("Job output:", 6, 1, 5, "effectedRows"));
    }

    private void addAction(String accountName) {
        String serverFull = this.obj.getAttribute("Op1_server");
        String port = serverFull.contains(":") ? serverFull.split(":")[1] : "";
        int portNumber = port.isEmpty() ? 0 : Integer.parseInt(port);
        String dbType = Globs.DATABASE_CP_TYPES.MSSQL.name();
        if (portNumber >= 1433 && portNumber <= 1440) {
            dbType = "PostgreSQL";
        } else if (portNumber >= 1521 && portNumber <= 1530) {
            dbType = "Oracle";
        } else if (portNumber >= 8471 && portNumber <= 8480) {
            dbType = "DB2";
        }
        UC4ConnectionsHelper.saveSqlConnection(accountName, dbType, this.obj.getAttribute("Op1_db"), this.obj.getAttribute("Op1_host"), port, this.obj.getAttribute("Op1_login"), "password");
    }

    private static class StopCyclic
    extends OnStatement {
        public StopCyclic(String operator, String value) {
            super("%%effectedRows " + operator, value);
            this.addDo((Do)Do.createDoStopCyclic());
        }
    }
}

