/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.CITWebServicesConverter;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class CITWebServicesRestConverter
extends CITWebServicesConverter {
    @Override
    public void convertToCm(UC4Job uc4Job) {
        XmlElement xml = uc4Job.getJobXmlElement();
        CITWebServicesConverter.ComponentHandler componentHandler = new CITWebServicesConverter.ComponentHandler(xml);
        uc4Job.setAttr("APPL_TYPE", "RST062023");
        uc4Job.addVariable("%%UCM-APP_NAME", "RST062023");
        uc4Job.setAttr("TASKTYPE", "Job");
        uc4Job.setAttr("APPL_VER", "9.0.21.000");
        uc4Job.setAttr("APPL_FORM", "RST062023");
        uc4Job.setAttr("CM_VER", "9.0.21.000");
        String restConnection = componentHandler.getComponent("restConnection").orElse("");
        String validatedRestConnectionName = UC4ConnectionsHelper.getValidatedConnectionProfileName(restConnection);
        uc4Job.addAttribute("OWNER", validatedRestConnectionName);
        uc4Job.addVariable("%%UCM-ACCOUNT", validatedRestConnectionName);
        componentHandler.getComponent("method").ifPresent(method -> uc4Job.addVariable("%%UCM-METHOD", (String)method));
        CITWebServicesRestConverter.convertTimeOut(uc4Job, componentHandler, restConnection);
        CITWebServicesRestConverter.convertRequestPath(uc4Job, componentHandler);
        this.covertEndPointUrl(uc4Job, restConnection);
        this.convertHeaders(uc4Job, restConnection);
    }

    private void convertHeaders(UC4Job uc4Job, String restConnection) {
        Map<String, String> headers = UC4ConnectionsHelper.getWebServiceHeaders(uc4Job.getUC4ObjectTablesMap(), restConnection);
        AtomicInteger index = new AtomicInteger(1);
        headers.forEach((headerName, headerValue) -> {
            uc4Job.addVariable(String.format("%%%%UCM-HEADERS_KEY_%03d", index.get()), (String)headerName);
            uc4Job.addVariable(String.format("%%%%UCM-HEADERS_VALUE_%03d", index.get()), (String)headerValue);
            index.getAndIncrement();
        });
    }

    private void covertEndPointUrl(UC4Job uc4Job, String connectionProfileName) {
        UC4ObjectTablesMap uc4ObjectData = uc4Job.getUC4ObjectTablesMap();
        String endPointUrl = UC4ConnectionsHelper.getWebServiceEndpoint(uc4ObjectData, connectionProfileName);
        uc4Job.addVariable("%%UCM-ENDPOINT_URL", endPointUrl);
    }

    private static void convertRequestPath(UC4Job uc4Job, CITWebServicesConverter.ComponentHandler componentHandler) {
        UnaryOperator convertToCtmVariable = s -> s.replaceAll("&(\\w*)#", "%%$1");
        Optional<String> resource = componentHandler.getComponent("resource");
        Optional query = componentHandler.getComponent("query_0_0").or(() -> componentHandler.getComponent("query_0_1")).map(convertToCtmVariable);
        Optional<String> resourceAndQuery = Stream.concat(resource.stream(), query.stream()).reduce((l, r) -> l + "&" + r);
        resourceAndQuery.ifPresent(r -> uc4Job.addVariable("%%UCM-URL_REQUEST_PATH", (String)r));
    }
}

