/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.CmConvertor;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Job;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

abstract class CITWebServicesConverter
implements CmConvertor {
    CITWebServicesConverter() {
    }

    protected static String getWebServiceConnectionTimeoutFromConnectionProfile(UC4Job uc4Job, String restConnection) {
        return UC4ConnectionsHelper.getWebServiceConnectionTimeout(uc4Job.getUC4ObjectTablesMap(), restConnection);
    }

    protected static void convertTimeOut(UC4Job uc4Job, ComponentHandler componentHandler, String restConnection) {
        String connectTimeout = componentHandler.getComponent("connectTimeout").filter(x -> !x.isEmpty()).orElse(CITWebServicesConverter.getWebServiceConnectionTimeoutFromConnectionProfile(uc4Job, restConnection));
        uc4Job.addVariable("%%UCM-CONN_TIMEOUT", connectTimeout);
    }

    protected static class ComponentHandler {
        private final Map<String, String> components;

        public ComponentHandler(XmlElement xml) {
            this.components = this.getAllComponentsFrom(xml);
        }

        private Map<String, String> getAllComponentsFrom(XmlElement xml) {
            XmlElement citElement = (XmlElement)xml.getAllDecnedElementByName("CIT").getFirst();
            List citComponentElements = citElement.getAllDecnedElementByName("component");
            return citComponentElements.stream().collect(Collectors.toMap(k -> k.getAttribute("xmlName"), v -> v.getAttribute("value")));
        }

        public Optional<String> getComponent(String componentName) {
            return Optional.ofNullable(this.components.get(componentName));
        }

        public Optional<List<String>> getAllComponentsWithRegex(String componentName, Comparator<String> comparator) {
            return Optional.of(this.components.keySet().stream().filter(key -> Pattern.matches(componentName, key)).sorted(comparator).map(this.components::get).collect(Collectors.toList()));
        }
    }
}

