/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.CITConvertor;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.handlers.variables.PromptsetVariablesResolver;
import java.util.Map;
import java.util.Optional;

public class CITOracleRetailConvertor
implements CITConvertor {
    @Override
    public void convertToCm(UC4Job uc4Job) {
        RealConvertor convertor = new RealConvertor(this, uc4Job);
        convertor.addOracleRetailAttributes();
        convertor.addOracleRetailVariables();
        convertor.cleanAttributes();
        this.addConvertedtoDummyMessage(uc4Job);
    }

    private void addConvertedtoDummyMessage(UC4Job uc4Job) {
        String originalJobName = uc4Job.getOriginalJobName();
        String jobName = uc4Job.getJobName();
        uc4Job.addMessage("WRN8040", originalJobName, jobName);
    }

    private class RealConvertor {
        private UC4Job uc4Job;
        private PromptsetVariablesResolver prompsetVariablesResolver;
        private Map<String, String> citComponentXmlName2Value;

        public RealConvertor(CITOracleRetailConvertor cITOracleRetailConvertor, UC4Job uc4Job) {
            this.uc4Job = uc4Job;
            this.prompsetVariablesResolver = uc4Job.getPrompsetVariablesResolver();
            this.citComponentXmlName2Value = cITOracleRetailConvertor.getCitXmlElementMap(uc4Job);
        }

        public void addOracleRetailAttributes() {
            this.uc4Job.addAttribute("APPL_TYPE", "RETAIL");
            this.uc4Job.addAttribute("APPL_VER", "8.0.00");
            this.uc4Job.addAttribute("APPL_FORM", "Oracle Retail");
            this.uc4Job.addAttribute("CM_VER", "N/A");
            this.uc4Job.addAttribute("TASKTYPE", "Job");
        }

        public void addOracleRetailVariables() {
            this.uc4Job.addVariable("%%RTL-EXEC_TYPE", "RMS");
            String objectName = this.getValueOrEmpty("program");
            objectName = this.getXmlValue(objectName);
            this.uc4Job.addVariable("%%RTL-EXEC_OBJECT_NAME", objectName);
            this.uc4Job.addVariable("%%RTL-IS_DEFAULT_PATH", "1");
            String threads = this.getValueOrEmpty("threads");
            threads = this.getXmlValue(threads);
            this.uc4Job.addVariable("%%RTL-THREAD_NUM", threads);
            String rerunAction = this.getValueOrEmpty("allowRecovery");
            rerunAction = this.getXmlValue(rerunAction);
            rerunAction = rerunAction.equals("Y") ? "1" : "0";
            this.uc4Job.addVariable("%%RTL-RERUN_ACTION", rerunAction);
            this.uc4Job.addVariable("%%RTL-ACCOUNT", "RETAIL_CONNECTION_PROFILE");
            this.uc4Job.addVariable("%%RTL-PARAM-N001", "$login");
        }

        private String getXmlValue(String varValue) {
            Optional<String> optThreads;
            if (this.prompsetVariablesResolver.isVariableName(varValue) && (optThreads = this.prompsetVariablesResolver.getVariableValue(varValue)).isPresent()) {
                varValue = optThreads.get();
            }
            return varValue;
        }

        private String getValueOrEmpty(String key) {
            String value = this.citComponentXmlName2Value.get(key);
            if (value == null) {
                value = "";
            }
            return value;
        }

        public void cleanAttributes() {
            this.uc4Job.addAttribute("MEMNAME", "");
        }
    }
}

