/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.CITOracleRetailConvertor;
import com.bmc.ctmconvert.uc4.CITWebServicesRestConverter;
import com.bmc.ctmconvert.uc4.CITWebServicesSoapConverter;
import com.bmc.ctmconvert.uc4.CmConvertor;
import com.bmc.ctmconvert.uc4.NotConvertedMessageHandler;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.cm.cit.CITFTPConvertor;
import com.bmc.ctmconvert.uc4.cm.cit.CITInformaticaConvertor;
import com.bmc.ctmconvert.uc4.cm.cit.CITOEBSConvertor;
import java.util.List;

public class CITConvertorFactory {
    private final UC4Job uc4Job;

    protected CITConvertorFactory(UC4Job uc4Job) {
        this.uc4Job = uc4Job;
    }

    public boolean isCITType() {
        UC4Object obj = this.uc4Job.getObj();
        String hostType = obj.getAttribute("HostATTR_Type");
        return hostType != null && hostType.equals("CIT");
    }

    private String getType() {
        XmlElement element = this.uc4Job.getJobXmlElement();
        List allDecnedElementByName = element.getAllDecnedElementByName("CIT");
        if (allDecnedElementByName == null || allDecnedElementByName.isEmpty()) {
            return "";
        }
        XmlElement citElement = (XmlElement)allDecnedElementByName.getFirst();
        XmlElement citContElement = (XmlElement)citElement.getAllDecnedElementByName("citcont").getFirst();
        return citContElement.getAttribute("jobtype");
    }

    public CmConvertor getConvertor() {
        if (this.getType().equals("ORACLERETAILAGENT")) {
            return new CITOracleRetailConvertor();
        }
        if (this.getType().equals("OEBSAGENT")) {
            return new CITOEBSConvertor();
        }
        if (this.getType().equals("FTPAGENT")) {
            return new CITFTPConvertor();
        }
        if (this.getType().equals("WEBSERVICEREST")) {
            return new CITWebServicesRestConverter();
        }
        if (this.getType().equals("WEBSERVICESOAP")) {
            return new CITWebServicesSoapConverter();
        }
        if (this.getType().equals("INFORMATICAAGENT")) {
            return new CITInformaticaConvertor();
        }
        return new NotConvertedMessageHandler();
    }
}

