/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.getter;

import com.bmc.ctmconvert.exception.NoRegexGroupMatchFoundException;
import com.bmc.ctmconvert.getter.AbstractFromStringGetter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringRegexGetter
extends AbstractFromStringGetter {
    private String regexPattern;

    public StringRegexGetter(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    @Override
    public Object getValueImplementation(String stringValue) {
        Pattern pattern = Pattern.compile(this.regexPattern);
        Matcher matcher = pattern.matcher(stringValue);
        if (!matcher.find()) {
            throw new NoRegexGroupMatchFoundException(this.regexPattern, stringValue);
        }
        String retValue = matcher.group(1);
        return retValue;
    }
}

