/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.EntityMapper;
import com.bmc.ctmconvert.InputStreamNamePair;
import com.bmc.ctmconvert.common.exceptions.ConversionRuntimeException;
import com.bmc.ctmconvert.getter.CtmEntityMapper;
import com.bmc.ctmconvert.scriptelement.CtmWorkspace;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import com.bmc.ctmconvert.workspace.Workspace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Context {
    private static CtmWorkspace workspace;
    private static List<InputStreamNamePair> inputData;
    private static List<Document> inputDataAsDocument;

    private Context() {
    }

    public static CtmWorkspace getWorkspace() {
        if (workspace == null) {
            workspace = Context.createWorkspaceWrapper(new Workspace());
        }
        return workspace;
    }

    private static CtmWorkspace createWorkspaceWrapper(Workspace workspace) {
        CtmEntityMapper ctmEntityMapper = new CtmEntityMapper();
        return new CtmWorkspace(workspace, ctmEntityMapper);
    }

    public static void setWorkspace(Workspace workspace) {
        Context.workspace = workspace == null ? null : Context.createWorkspaceWrapper(workspace);
    }

    public static List<InputStreamNamePair> getInputData() {
        return new ArrayList<InputStreamNamePair>(inputData);
    }

    public static void addInputData(InputStreamNamePair ... newData) {
        Context.addInputData(Arrays.asList(newData));
    }

    public static void addInputData(List<InputStreamNamePair> newData) {
        inputData.addAll(newData);
    }

    public static void setInputData(List<InputStreamNamePair> inputData) {
        Context.inputData = inputData;
    }

    public static List<Document> getInputDataAsDocument() {
        if (inputDataAsDocument == null) {
            Context.generateInputDataAsDocument();
        }
        return new ArrayList<Document>(inputDataAsDocument);
    }

    private static void generateInputDataAsDocument() {
        String filename = "";
        inputDataAsDocument = new ArrayList<Document>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder parser = factory.newDocumentBuilder();
            for (InputStreamNamePair input : inputData) {
                filename = input.getFileName();
                InputSource is = Context.setEncoding(input);
                Document document = parser.parse(is);
                inputDataAsDocument.add(document);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ConversionRuntimeException(String.format("Input data XML file %S contains an invalid XML structure.  \r\nPlease fix the file and reload the input data files.", filename));
        }
    }

    private static InputSource setEncoding(InputStreamNamePair input) {
        InputSource is = new InputSource(input.getInputStream());
        String encodingProperty = SettingsTable.instance().getProperty(SettingsStringKeys.XML_ENCODING_VALUE);
        String xmlEncodingValue = encodingProperty.equals("") ? null : encodingProperty;
        is.setEncoding(xmlEncodingValue);
        return is;
    }

    public static void reset() {
        workspace = null;
        inputData = new ArrayList<InputStreamNamePair>();
        inputDataAsDocument = null;
        EntityMapper.workspaceEntityToXmlEntity = null;
        EntityMapper.xmlElementToEntity = null;
    }

    static {
        inputData = new ArrayList<InputStreamNamePair>();
        inputDataAsDocument = null;
    }
}

