/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.sql_query;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.SqlTaskParser;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.StoredProc;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.StoredProcConvertor;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.StoredProcedureParameter;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import org.w3c.dom.Element;

public class StoredProcTask
extends ZenaTask {
    private final SqlTaskParser sqlTaskParser;
    private final StoredProc storedProc = new StoredProc();
    private final XmlElement taskDefinition;

    public StoredProcTask(Element entityDefnition, ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        super(entityDefnition, job);
        this.sqlTaskParser = new SqlTaskParser(entitiesDefinitionsManager, XmlElement.ofNullable((Element)this.getEntityDefinition()), this.storedProc);
        this.taskDefinition = XmlElement.ofNullable((Element)entityDefnition);
    }

    @Override
    public String getControlMTaskType() {
        return "Job";
    }

    @Override
    protected void convertTaskType() {
        this.sqlTaskParser.parseTask(this::processAttribute, this.getEntityAttributes());
        this.parseParameters();
        new StoredProcConvertor(this.storedProc, this.job, this.zenaVariablesHandler).convert();
    }

    private void parseParameters() {
        ZenaXmlUtils.extractParametersOrdered(this.taskDefinition).forEach(this::convertVariableToParameter);
    }

    private void convertVariableToParameter(XmlElement variable) {
        StoredProcedureParameter parameter = new StoredProcedureParameter();
        parameter.NAME = variable.getAttribute("NAME");
        parameter.DIRECTION = variable.getAttribute("DIRECTION");
        parameter.EXTTYPE = variable.getAttribute("EXTTYPE");
        parameter.VALUE = variable.getText();
        this.storedProc.parameters.add(parameter);
    }

    void processAttribute(XmlElement attribute) {
        String tagName = attribute.getTagName();
        String innerText = attribute.getText();
        switch (tagName) {
            case "STOREDPROCEDURE": {
                this.storedProc.STOREDPROCEDURE = innerText;
                break;
            }
            default: {
                this.sqlTaskParser.processAttribute(attribute);
            }
        }
    }
}

