/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.sql_query;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.run_as.LoginData;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.SqlTask;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.w3c.dom.Element;

public class SqlTaskParser {
    XmlElement taskDefinition;
    SqlTask sqlTask;
    EntitiesDefinitionsManager entitiesDefinitionsManager;

    public SqlTaskParser(EntitiesDefinitionsManager entitiesDefinitionsManager, XmlElement taskDefinition, SqlTask sqlTask) {
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        this.taskDefinition = taskDefinition;
        this.sqlTask = sqlTask;
    }

    void parseTask(Consumer<XmlElement> attributeProcessor, Element entityAttributes) {
        this.parseTaskAttributes(attributeProcessor);
        this.sqlTask.LOGIN = this.parseLoginName();
        XmlElement dataBaseNameElement = XmlElement.ofNullable((Element)entityAttributes).getFirstChildElementByName("DATABASE");
        this.sqlTask.DATABASENAME = dataBaseNameElement == null ? "defaultDB" : dataBaseNameElement.getValue();
    }

    void parseTaskAttributes(Consumer<XmlElement> attributeProcessor) {
        Optional.ofNullable(this.taskDefinition.getFirstChildElementByName("ATTRIBUTES")).map(XmlElement::getAllDirectchildsElement).orElse(Collections.emptyList()).forEach(attributeProcessor);
    }

    void processAttribute(XmlElement attribute) {
        String tagName = attribute.getTagName();
        String innerText = attribute.getText();
        if (tagName.equals("FORMAT")) {
            this.sqlTask.FORMAT = innerText;
        } else if (tagName.equals("APPEND_OUTPUT")) {
            this.sqlTask.APPEND_OUTPUT = innerText;
        }
    }

    LoginData parseLoginName() {
        Optional<Element> optionalLoginElement = Optional.ofNullable(this.taskDefinition.getFirstChildElementByName("LOGIN")).map(loginElement -> loginElement.getAttribute("UID")).map(loginUid -> this.entitiesDefinitionsManager.getElementByTypeAndID("LOGIN", (String)loginUid));
        return LoginData.parseLoginDefinition(optionalLoginElement);
    }
}

