/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.script;

import java.util.regex.Pattern;

public class ScriptVariable {
    private final Pattern pattern;
    private final String name;
    private final String type;

    public ScriptVariable(String name, String type) {
        this(Pattern.compile(""), name, type);
    }

    public ScriptVariable(Pattern pattern, String name, String type) {
        this.pattern = pattern;
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isProcessVariable() {
        return "PROCESS".equalsIgnoreCase(this.type);
    }

    public boolean isSystemVariable() {
        return "SYSTEM".equalsIgnoreCase(this.type);
    }

    public String toString() {
        return "ZenaVariable{name='" + this.name + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptVariable that = (ScriptVariable)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean isLocalVariable() {
        return !this.isSystemVariable() && !this.isProcessVariable();
    }

    public boolean isVariableSet() {
        return this.pattern.toString().toLowerCase().contains("setvariablevalue");
    }
}

