/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.script;

import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.tasktypes.script.JavaScriptHandler;
import com.bmc.ctmconvert.zena.tasktypes.script.PythonScriptHandler;
import com.bmc.ctmconvert.zena.tasktypes.script.ScriptReplacer;
import com.bmc.ctmconvert.zena.tasktypes.script.ScriptVariable;
import com.bmc.ctmconvert.zena.tasktypes.script.VBScriptHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public abstract class ScriptHandler {
    private final List<ScriptVariable> variablesFromScript;
    final String script;
    private final List<String> messageIds = new ArrayList<String>();
    protected final ScriptReplacer scriptReplacer;

    protected ScriptHandler(String script, ZenaVariablesHandler zenaVariablesHandler, RulesDataSet rules) {
        this.script = script;
        this.variablesFromScript = new ArrayList<ScriptVariable>();
        this.scriptReplacer = new ScriptReplacer(zenaVariablesHandler, this::getVariablesFromScript, rules);
    }

    public static ScriptHandler createScriptHandler(String fileNameExtension, String script, ZenaVariablesHandler zenaVariablesHandler, RulesDataSet rules) {
        return switch (fileNameExtension) {
            case ".vbs" -> new VBScriptHandler(script, zenaVariablesHandler, rules);
            case ".js" -> new JavaScriptHandler(script, zenaVariablesHandler, rules);
            case ".py" -> new PythonScriptHandler(script, zenaVariablesHandler, rules);
            default -> new EmptyScriptHandler(script);
        };
    }

    public boolean isScriptIgnored() {
        Predicate<String> isNullOrEmpty = inputScript -> inputScript == null || inputScript.isEmpty();
        Predicate<String> isScriptContentInVariable = inputScript -> {
            if (ZenaVariablesHandler.variablePattern.matcher((CharSequence)inputScript).matches()) {
                this.getMessageIds().add("WRN15044");
                return true;
            }
            return false;
        };
        return isNullOrEmpty.or(isScriptContentInVariable).test(this.script);
    }

    public String handle() {
        if (this.isScriptIgnored()) {
            return this.script;
        }
        return this.handleScript();
    }

    private String handleScript() {
        return (String)this.scriptReplacer.addMessageForUnsupportedVariableUsages(this::getMessageIds).andThen(this.scriptReplacer.replaceGetVariableValueFor("Item", this.getExpandEnvironsVariables())).andThen(this.scriptReplacer.replaceGetVariableValueFor("Process", this.getExpandEnvironsVariables())).andThen(this.scriptReplacer.replaceVariablesFor("PROCESS", this.getExpandEnvironsVariables())).andThen(this.scriptReplacer.replaceVariablesFor("SYSTEM", this.getExpandEnvironsVariables())).andThen(this.scriptReplacer.replaceVariablesFor("TASK", this.getExpandEnvironsVariables())).andThen(this.scriptReplacer.replaceSetVariableValueForItem(this.getItemCTMVarCommand())).andThen(this.scriptReplacer.replaceSetVariableValueForProcess(this.getProcessCtmVarCommand())).andThen(this.scriptReplacer.replaceItemAppendOutput(this.getEchoFunction())).andThen(this.scriptReplacer.replaceItemSetOutput(this.getEchoFunction())).andThen(this.addHeaderAndFooter(this.getHeader(), this.getFooter())).apply(this.script);
    }

    protected abstract String getHeader();

    protected abstract String getFooter();

    protected abstract String getEchoFunction();

    protected abstract String getProcessCtmVarCommand();

    protected abstract String getItemCTMVarCommand();

    protected abstract String getExpandEnvironsVariables();

    public List<String> getMessageIds() {
        return this.messageIds;
    }

    public List<ScriptVariable> getVariablesFromScript() {
        return this.variablesFromScript;
    }

    protected UnaryOperator<String> addHeaderAndFooter(String header, String footer) {
        return inputScript -> {
            if (this.isScriptModified().test((String)inputScript)) {
                return header + inputScript + footer;
            }
            return this.script;
        };
    }

    public abstract String getCommandPath();

    protected Predicate<String> isScriptModified() {
        return inputScript -> !this.script.equals(inputScript);
    }

    public boolean isSupportedScript() {
        return true;
    }

    public abstract String getExternalPathRuleName();

    public static class EmptyScriptHandler
    extends ScriptHandler {
        public EmptyScriptHandler(String script) {
            super(script, null, null);
        }

        @Override
        public String handle() {
            return this.script;
        }

        @Override
        protected String getHeader() {
            return "";
        }

        @Override
        protected String getFooter() {
            return "";
        }

        @Override
        protected String getEchoFunction() {
            return "";
        }

        @Override
        protected String getProcessCtmVarCommand() {
            return "";
        }

        @Override
        protected String getItemCTMVarCommand() {
            return "";
        }

        @Override
        protected String getExpandEnvironsVariables() {
            return "";
        }

        @Override
        public String getCommandPath() {
            return "";
        }

        @Override
        public boolean isSupportedScript() {
            return false;
        }

        @Override
        public String getExternalPathRuleName() {
            return "";
        }
    }
}

