/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoNotOk;
import com.bmc.ctmconvert.ondo.DoOk;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class ExitCodeConverter {
    private final ZenaJob zenaJob;
    private final XmlElement taskDefinition;
    private final ExitCodesExtractor extractor;

    public ExitCodeConverter(ZenaJob zenaJob, Element entityDefinition) {
        this.zenaJob = zenaJob;
        this.taskDefinition = XmlElement.ofNullable((Element)entityDefinition);
        this.extractor = new ExitCodesExtractor();
    }

    public void convert() {
        this.getExitCodeValue().ifPresent(value -> {
            Collection<Integer> exitCodes = this.extractor.extractExitCodes((String)value);
            if (ExitCodeConverter.isConsecutiveRange(exitCodes)) {
                this.convertExitCodeRange(exitCodes);
            } else {
                if (this.hasNoZeroExitCode(exitCodes)) {
                    this.convertZeroExitCode();
                }
                exitCodes.forEach(this::convertToOnDo);
            }
        });
    }

    static boolean isConsecutiveRange(Collection<Integer> exitCodes) {
        List distinctCodes = exitCodes.stream().distinct().sorted().collect(Collectors.toList());
        if (distinctCodes.size() <= 1) {
            return false;
        }
        for (int i = 1; i < distinctCodes.size(); ++i) {
            if ((Integer)distinctCodes.get(i) - (Integer)distinctCodes.get(i - 1) == 1) continue;
            return false;
        }
        return true;
    }

    private static Optional<Integer> getMax(Collection<Integer> exitCodes) {
        return exitCodes.stream().reduce(Math::max);
    }

    private static Optional<Integer> getMin(Collection<Integer> exitCodes) {
        return exitCodes.stream().reduce(Math::min);
    }

    private void convertExitCodeRange(Collection<Integer> exitCodes) {
        Optional<Integer> max = ExitCodeConverter.getMax(exitCodes);
        Optional<Integer> min = ExitCodeConverter.getMin(exitCodes);
        max.ifPresent(value -> {
            OnStatement on = OnStatement.createOnCompletionStatusLessThenEquals((int)value).addDo((Do)new DoOk());
            this.zenaJob.addOnDoStatement(on);
        });
        min.ifPresent(value -> {
            OnStatement on = OnStatement.createOnCompletionStatusLessThen((int)value).addDo((Do)new DoNotOk());
            this.zenaJob.addOnDoStatement(on);
        });
    }

    private void convertZeroExitCode() {
        OnStatement nonZero = OnStatement.createOnCompletionStatusNotEquals((int)0).addDo(Do.createDoNotOk());
        this.zenaJob.addOnDoStatement(nonZero);
    }

    private boolean hasNoZeroExitCode(Collection<Integer> exitCodes) {
        return !exitCodes.isEmpty() && exitCodes.stream().noneMatch(x -> x == 0);
    }

    private void convertToOnDo(int exitCode) {
        if (0 != exitCode) {
            OnStatement on = OnStatement.createOnCompletionStatus((int)exitCode).addDo((Do)new DoOk());
            this.zenaJob.addOnDoStatement(on);
        }
    }

    private Optional<String> getExitCodeValue() {
        Optional<String> exitCodes = this.taskDefinition.getAllDecnedElementByName("ATTRIBUTES").stream().findFirst().map(x -> x.getFirstChildElementByName("EXIT_CODES")).map(XmlElement::getText);
        return exitCodes.map(ec -> {
            if (this.extractor.isVariable((String)ec)) {
                this.zenaJob.addMessageWithJobNameAndOriginalJobName("WRN15052", (String)ec);
            }
            return ec;
        });
    }

    public static class ExitCodesExtractor {
        private static final Pattern RANGE_PATTERN = Pattern.compile("(?<start>\\d+)-(?<end>\\d+)");
        private Matcher rangeMatcher;

        public Collection<Integer> extractExitCodes(String value) {
            if (this.isVariable(value)) {
                return Collections.emptyList();
            }
            if (this.isRange(value)) {
                return this.getRange();
            }
            return this.splitExitCodes(value);
        }

        private boolean isRange(String exitCodes) {
            this.rangeMatcher = this.createRangeMatcher(exitCodes);
            return this.rangeMatcher.matches();
        }

        private Matcher createRangeMatcher(String exitCodes) {
            return RANGE_PATTERN.matcher(exitCodes);
        }

        private List<Integer> getRange() {
            int start = Integer.parseInt(this.rangeMatcher.group("start"));
            int end = Integer.parseInt(this.rangeMatcher.group("end"));
            return IntStream.range(start, end + 1).boxed().distinct().collect(Collectors.toList());
        }

        private List<Integer> splitExitCodes(String value) {
            return Stream.of(value.split(",")).filter(s -> !s.isBlank()).distinct().filter(GlobalFunctions::isNumber).map(Integer::parseInt).collect(Collectors.toList());
        }

        private boolean isVariable(String exitCodes) {
            return ZenaVariablesHandler.variablePattern.matcher(exitCodes).matches();
        }
    }
}

