/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.tasktypes.ZenaTask;
import com.bmc.ctmconvert.zena.utils.ZenaUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public abstract class BaseFtpTask
extends ZenaTask {
    private final EntitiesDefinitionsManager entitiesDefinitionsManager;

    public BaseFtpTask(Element entityDefinition, ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        super(entityDefinition, job);
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
    }

    @Override
    public String getControlMTaskType() {
        if (this.isSupported()) {
            return "Job";
        }
        return "Dummy";
    }

    protected EntitiesDefinitionsManager getEntitiesDefinitionsManager() {
        return this.entitiesDefinitionsManager;
    }

    @Override
    protected void convertTaskType() {
        this.setFileTransferJobAttributes();
        this.convertLeftAttributes();
        this.convertRightAttributes();
        this.convertFileTransferAttributes();
        this.convertFileTransferAction();
        this.addActionForConnectionProfile();
        this.convertFileTransferAccount();
        this.convertMemLib();
    }

    protected abstract boolean isSupported();

    private void convertRightAttributes() {
        this.convertRightHost();
        this.convertRightUser();
        this.convertRightPath();
    }

    private void convertLeftAttributes() {
        this.convertLeftHost();
        this.convertLeftUser();
        this.convertLeftPath();
    }

    private void convertLeftPath() {
        this.job.addAutoEdits("%%FTP-LPATH1", this.zenaVariablesHandler.annotateVariables(this.getLeftPath(this.job)));
    }

    protected void convertMemLib() {
        this.setMemLib("Not in use for application jobs");
    }

    private void convertFileTransferAction() {
        FTP_COMMAND command = this.getFileTransferAction(this.job);
        String fileTransferAction = "1";
        if (command.equals((Object)FTP_COMMAND.PUT) || command.equals((Object)FTP_COMMAND.MPUT)) {
            fileTransferAction = "1";
        } else if (command.equals((Object)FTP_COMMAND.GET) || command.equals((Object)FTP_COMMAND.MGET)) {
            fileTransferAction = "0";
        } else {
            String ctmFileTransferActionDescription = this.getCtmFileTransferActionDescription(fileTransferAction);
            this.unsupportedFtpCommand(this.job, ctmFileTransferActionDescription, command.toString());
        }
        this.job.addAutoEdits("%%FTP-UPLOAD1", fileTransferAction);
    }

    private String getCtmFileTransferActionDescription(String fileTransferAction) {
        if (fileTransferAction.equals("1")) {
            return "Transfer from left to right";
        }
        return "Transfer from right to left";
    }

    private void unsupportedFtpCommand(ZenaJob job, String ctmFileTransferAction, String zenaFtpAction) {
        job.addMessageWithJobNameAndOriginalJobName("WRN15041", ctmFileTransferAction, zenaFtpAction);
    }

    protected abstract FTP_COMMAND getFileTransferAction(ZenaJob var1);

    protected void convertFileTransferAttributes() {
        this.job.addAutoEdits("%%FTP-TYPE1", "A");
        this.job.addAutoEdits("%%FTP-IF_EXIST1", "0");
        this.job.addAutoEdits("%%FTP-SRCOPT1", "0");
        this.job.addAutoEdits("%%FTP-RECURSIVE1", "0");
        this.job.addAutoEdits("%%FTP-TRANSFER_NUM", "1");
    }

    protected void convertRightPath() {
        this.job.addAutoEdits("%%FTP-RPATH1", this.zenaVariablesHandler.annotateVariables(this.getRightPath()));
    }

    protected abstract String getRightPath();

    private void convertRightUser() {
        this.job.addAutoEdits("%%FTP-RUSER", this.getRemoteUser());
    }

    private void convertRightHost() {
        this.job.addAutoEdits("%%FTP-RHOST", this.getRemoteHost());
    }

    protected abstract String getLeftPath(ZenaJob var1);

    private void convertLeftUser() {
        this.job.addAutoEdits("%%FTP-LUSER", this.getLocalUser());
    }

    private void convertLeftHost() {
        this.job.addAutoEdits("%%FTP-LHOST", this.job.getAttr("NODEID"));
    }

    private String buildLocalFileTransferAccount() {
        String localHost = ZenaUtils.buildAftAccount("Local_CP", this.getLocalUser());
        String remoteHost = this.buildFileTransferAccount();
        return localHost + "+" + remoteHost;
    }

    protected void convertFileTransferAccount() {
        this.job.addAutoEdits("%%FTP-ACCOUNT", this.buildLocalFileTransferAccount());
    }

    private String buildFileTransferAccount() {
        String remoteHostForAccount = this.extractHostName(this.getRemoteHost());
        return ZenaUtils.buildAftAccount(remoteHostForAccount, this.getRemoteUser());
    }

    private String getLocalUser() {
        return ZenaUtils.extractUserAccount(this.job.getAttr("OWNER") == null ? "" : this.job.getAttr("OWNER"));
    }

    private Optional<Element> getLoginDefinition() {
        Element loginDefinition = null;
        Element agent = (Element)super.getEntityDefinition().getElementsByTagName("LOGIN").item(0);
        if (agent != null) {
            String agentUID = agent.getAttribute("UID");
            loginDefinition = this.getEntitiesDefinitionsManager().getElementByTypeAndID("LOGIN", agentUID);
        }
        return Optional.ofNullable(loginDefinition);
    }

    private String getAttributeFromLoginDefinition(String xmlAttributeLogin) {
        return this.getLoginDefinition().map(login -> login.getAttribute(xmlAttributeLogin)).orElse("");
    }

    private String getRemoteHost() {
        return this.getAttributeFromLoginDefinition("HOST");
    }

    private String getRemoteUser() {
        return ZenaUtils.extractUserAccount(this.getAttributeFromLoginDefinition("LOGIN"));
    }

    protected void setFileTransferJobAttributes() {
        this.job.setOptionalAttribute("APPL_FORM", "AFT");
        this.job.setOptionalAttribute("APPL_TYPE", "FILE_TRANS");
        this.job.setOptionalAttribute("APPL_VER", "6.1.01");
        this.job.setOptionalAttribute("CM_VER", "610");
    }

    private String extractHostName(String remoteHostForAccount) {
        if (remoteHostForAccount.contains(".")) {
            remoteHostForAccount = remoteHostForAccount.substring(0, remoteHostForAccount.indexOf(46));
        }
        return remoteHostForAccount;
    }

    protected void addActionForConnectionProfile() {
        String nodeId = this.job.getAttr("NODEID");
        String params = String.format("%s=%s;%s=%s;%s=%s;%s=%s;%s=%s;%s=%s;%s=%s;%s=%s;%s=%s", "AFTCPTYPE", Globs.AFT_ACCOUNT_TYPES.LOCAL_TO_FTP.name(), "SERVER", Params.instance().getDatacenterName(), "AFTLOSTYPE", this.getOsType(), "AFTLTARGETAGENT", nodeId, "AFTLUSER", this.getLocalUser(), "AFTROSTYPE", "Unix", "AFTRARGETAGENT", nodeId, "AFTRUSER", this.getRemoteUser(), "AFTRHOST", this.getRemoteHost());
        HashMap<String, String> fileTransferAction = new HashMap<String, String>();
        fileTransferAction.put("ACTENTTYPE", "AFTACC");
        fileTransferAction.put("JOBID", this.job.getAttr("JOBNAME"));
        fileTransferAction.put("ACTENTNAME", this.buildLocalFileTransferAccount());
        fileTransferAction.put("ACTSTATUS", "0");
        fileTransferAction.put("ACTPARAMETERS", params);
        this.job.addAction(fileTransferAction);
    }

    private String getOsType() {
        String dsJobOsType = this.job.isDSJob() ? "Unix" : "MVS";
        return this.job.isWindows() ? "Windows" : dsJobOsType;
    }

    static enum FTP_COMMAND {
        DELETE,
        MDELETE,
        GET,
        MGET,
        MKDIR,
        CHDIR,
        SITE,
        RENAME,
        PUT,
        MPUT,
        UNKNOWN;

        private static final Map<String, FTP_COMMAND> mapping;

        private static Map<String, FTP_COMMAND> initializeMapping() {
            return Arrays.stream(FTP_COMMAND.values()).collect(Collectors.toMap(Enum::toString, value -> value));
        }

        public static FTP_COMMAND from(String command) {
            return mapping.getOrDefault(command, UNKNOWN);
        }

        static {
            mapping = FTP_COMMAND.initializeMapping();
        }
    }
}

