/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.run_as;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.run_as.ZenaRunAsData;
import java.util.Optional;
import org.w3c.dom.Element;

public class ZenaRunAsDataCreator {
    private XmlElement entityProcessData;
    private EntitiesDefinitionsManager entitiesDefinitionsManager;

    public ZenaRunAsDataCreator(XmlElement entityProcessData, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        this.entityProcessData = entityProcessData;
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
    }

    public ZenaRunAsData create() {
        ZenaRunAsData runAsData = new ZenaRunAsData();
        runAsData.type = this.entityProcessData.getTagName();
        runAsData.overrideLogin.LOGIN = this.tryFindingOverrideLogin();
        runAsData.taskDefinitionsLogin.LOGIN = this.tryFindingTaskLogin();
        runAsData.usesAgentSecurity = this.determineAgentSecurity();
        return runAsData;
    }

    private Optional<String> tryFindingOverrideLogin() {
        return Optional.ofNullable(this.entityProcessData).map(entityProcessDataElement -> entityProcessDataElement.getFirstChildElementByName("LOGIN")).filter(loginElement -> "OVERRIDE".equals(loginElement.getAttribute("LOGINTYPE"))).map(overrideLoginElement -> overrideLoginElement.getAttribute("UID")).flatMap(loginUid -> this.getLoginDefinition((String)loginUid)).map(loginDefinition -> loginDefinition.getAttribute("LOGIN"));
    }

    private Optional<String> tryFindingTaskLogin() {
        return Optional.ofNullable(this.entityProcessData).map(entityProcessDataElement -> entityProcessDataElement.getAttribute("UID")).flatMap(taskUid -> this.getTaskDefinition((String)taskUid)).map(task -> task.getFirstChildElementByName("LOGIN")).map(login -> login.getAttribute("UID")).flatMap(loginUid -> this.getLoginDefinition((String)loginUid)).map(loginDefinition -> loginDefinition.getAttribute("LOGIN"));
    }

    private Optional<XmlElement> getLoginDefinition(String uid) {
        Element loginDefinition = this.entitiesDefinitionsManager.getElementByTypeAndID("LOGIN", uid);
        return this.toXmlElement(loginDefinition);
    }

    private Optional<XmlElement> getTaskDefinition(String uid) {
        Element taskDefinition = this.entitiesDefinitionsManager.getElementByTypeAndID("TASK", uid);
        return this.toXmlElement(taskDefinition);
    }

    private Optional<XmlElement> toXmlElement(Element taskDefinition) {
        return Optional.ofNullable(taskDefinition).map(XmlElement::new);
    }

    private boolean determineAgentSecurity() {
        return Optional.ofNullable(this.entityProcessData).map(entityProcessDataElement -> entityProcessDataElement.getAttribute("UID")).flatMap(taskUid -> this.getTaskDefinition((String)taskUid)).flatMap(taskDefinition -> taskDefinition.getAllDecnedElementByName("AGENT_SECURITY").stream().findFirst()).map(agentSecurityElement -> agentSecurityElement.getText()).filter(agentSecurityValue -> "YES".equals(agentSecurityValue)).isPresent();
    }
}

