/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers.actions;

import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionsData;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionsDataCreator;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionsFactory;
import java.util.List;
import java.util.stream.Collectors;

public class ZenaActionHandler {
    private ZenaJob job;
    private ZenaActionsDataCreator creator;

    public ZenaActionHandler(ZenaJob job, ZenaActionsDataCreator creator) {
        this.job = job;
        this.creator = creator;
    }

    public void handle() {
        List<ZenaActionsData> actionsDataList = this.creator.parseActionsList();
        List<ZenaActionsData> sanitizedActions = this.removeAbnormalActionIfErrorActionIsDefined(actionsDataList);
        for (ZenaActionsData action : sanitizedActions) {
            this.convertActionToOnDo(action);
        }
    }

    private List<ZenaActionsData> removeAbnormalActionIfErrorActionIsDefined(List<ZenaActionsData> actionsDataList) {
        return actionsDataList.stream().filter(action -> !this.isAbnormalAction((ZenaActionsData)action) || this.noneMatchingErrorActionWithSameUID(actionsDataList, (ZenaActionsData)action)).collect(Collectors.toList());
    }

    private boolean isAbnormalAction(ZenaActionsData action) {
        return "ABNORMAL".equals(action.eventType);
    }

    private boolean noneMatchingErrorActionWithSameUID(List<ZenaActionsData> actionsDataList, ZenaActionsData action) {
        return actionsDataList.stream().noneMatch(anAction -> "ERROR".equals(anAction.eventType) && action.uid.isPresent() && action.uid.equals(anAction.uid));
    }

    private void convertActionToOnDo(ZenaActionsData action) {
        new ZenaActionsFactory(action, this.job).createActionConvertor().convertAction();
    }
}

