/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers.actions;

import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.actions.SendAlertActionItemConvertor;
import com.bmc.ctmconvert.zena.handlers.actions.SendMailActionItemConvertor;
import com.bmc.ctmconvert.zena.handlers.actions.WriteLogActionItemConvertor;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionItem;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionItemConvertor;
import java.util.Map;

public class ActionItemConvertorFactory {
    public static ZenaActionItemConvertor emptyConvertor = () -> {};
    private final MessageHandler messageHandler;

    public ActionItemConvertorFactory(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public ZenaActionItemConvertor createActionItemConvertor(OnStatement onStatement, ZenaActionItem actionItem, Map<String, String> variables, ZenaJob job) {
        ZenaActionItemConvertor convertor = emptyConvertor;
        switch (actionItem.actionType) {
            case "SEND_EMAIL": {
                convertor = new SendMailActionItemConvertor(onStatement, actionItem, variables, job);
                break;
            }
            case "SEND_ALERT": {
                convertor = new SendAlertActionItemConvertor(onStatement, actionItem, variables, job);
                break;
            }
            case "WRITE_LOG": {
                convertor = new WriteLogActionItemConvertor(onStatement, actionItem, variables, job);
                break;
            }
            default: {
                this.messageHandler.handleMessage("WRN15036", new String[]{actionItem.actionType});
            }
        }
        return convertor;
    }
}

