/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers.actions;

import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.handlers.actions.ZenaActionItemConvertor;
import java.util.Map;

public abstract class AbstractActionItemConvertor
implements ZenaActionItemConvertor {
    private final OnStatement onStatement;
    private final ZenaVariablesHandler variablesHandler;
    protected final Map<String, String> variables;
    protected ZenaJob job;

    public AbstractActionItemConvertor(OnStatement onStatement, Map<String, String> variables, ZenaJob job) {
        this.onStatement = onStatement;
        this.variables = variables;
        this.variablesHandler = job.getZenaVariablesHandler();
        this.job = job;
    }

    @Override
    public void convert() {
        this.onStatement.addDo(this.convertActionItem());
    }

    protected abstract Do convertActionItem();

    protected String annotateVariables(String variable) {
        String replacedVariable = this.replaceVariables(variable);
        return replacedVariable;
    }

    private String annotateVariableValue(String variableValue) {
        return this.variablesHandler.annotateVariables(variableValue);
    }

    private String toActionVariableFormat(String variableName) {
        return "[ACTION.VARIABLE." + variableName + "]";
    }

    private String toItemVariableFormat(String variableName) {
        return "[ITEM.VARIABLE." + variableName + "]";
    }

    private String toTaskVariableFormat(String variableName) {
        return "[TASK.VARIABLE." + variableName + "]";
    }

    private String replaceVariables(String inputVariableValue) {
        for (Map.Entry<String, String> nameAndValue : this.variables.entrySet()) {
            String variableName = nameAndValue.getKey();
            String variableValue = nameAndValue.getValue();
            inputVariableValue = this.replaceActionAndItemVariables(inputVariableValue, variableName, variableValue);
        }
        return this.annotateVariableValue(inputVariableValue);
    }

    private String replaceActionAndItemVariables(String inputVariableValue, String variableName, String variableValue) {
        String annotateVariableValue = this.annotateVariableValue(variableValue);
        String newVariableValue = inputVariableValue.replace(this.toActionVariableFormat(variableName), annotateVariableValue).replace(this.toItemVariableFormat(variableName), annotateVariableValue).replace(this.toTaskVariableFormat(variableName), annotateVariableValue);
        return newVariableValue;
    }
}

