/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.handlers;

import com.bmc.ctmconvert.common.AutoEditsConcatenator;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.interfaces.VariableResolver;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.folders.FolderPath;
import com.bmc.ctmconvert.zena.folders.ZenaFolderHierarchy;
import com.bmc.ctmconvert.zena.handlers.ItemVariablesHandler;
import com.bmc.ctmconvert.zena.handlers.UnsupportedZenaVariables;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class ZenaVariablesHandler {
    public static final String SYSTEM_VARIABLE_PREFIX = "SYSTEM.VARIABLE.";
    private static final String SMART_FOLDER_VARIABLE_PREFIX = "%%\\\\";
    private final ItemVariablesHandler itemVariablesHandler = new ItemVariablesHandler(this);
    public static final Pattern variablePattern = Pattern.compile("\\[([^\\[\\]]+)\\]");
    private final UnsupportedZenaVariables variablesChecker = new UnsupportedZenaVariables();
    private final ZenaJob job;
    private final XmlElement entityProcessData;
    private final EntitiesDefinitionsManager entitiesDefinitionsManager;
    private Map<String, String> zenaBuiltInVariablesMapping;

    public ZenaVariablesHandler(EntitiesDefinitionsManager entitiesDefinitionsManager) {
        this(null, null, entitiesDefinitionsManager);
    }

    public ZenaVariablesHandler(ZenaJob job, Element entityProcessData, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        this.job = job;
        this.entityProcessData = XmlElement.ofNullable((Element)entityProcessData);
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
        this.zenaBuiltInVariablesMapping = this.createZenaBuiltInVariableMap();
    }

    private Map<String, String> createZenaBuiltInVariableMap() {
        return Map.of("TASK.NAME", "%%JOBNAME", "PROCESS.NAME", "%%SCHEDTAB");
    }

    public String replaceZenaVariableWithItsValue(String str, VariableResolver valueResolver) {
        String result = str;
        Matcher m = variablePattern.matcher(str);
        while (m.find()) {
            String resolvedVar;
            String matchVarName = m.group(1);
            if (matchVarName.equals(resolvedVar = valueResolver.resolve(matchVarName))) continue;
            result = result.replace(m.group(0), resolvedVar);
        }
        return result;
    }

    public String annotateVariables(String stringWithVariableReferences) {
        AutoEditsConcatenator autoEditsConcatenator = new AutoEditsConcatenator(variablePattern);
        return autoEditsConcatenator.concat(this.removeTaskOutputVariable(stringWithVariableReferences), this::replaceZenaVariableWithCtmVariable);
    }

    private String removeTaskOutputVariable(String stringWithVariableReferences) {
        return stringWithVariableReferences.replace("[TASK.OUTPUT]", "");
    }

    public String replaceZenaVariableWithCtmVariable(String zenaVariableName) {
        String ctmVarName = zenaVariableName;
        if (this.variablesChecker.isStartingWithZenaVariablePrefix(zenaVariableName.toUpperCase())) {
            if (zenaVariableName.startsWith("SYSTEM") && this.job != null) {
                String systemVariableAction = GlobalFunctions.removeVariablePrefix((String)this.convertToCtmVariableName(zenaVariableName));
                this.addGlobalVariableAction(this.job.getTablePathForSons(), systemVariableAction);
            }
            if (this.itemVariablesHandler.isItemsVariable(zenaVariableName)) {
                ctmVarName = this.itemVariablesHandler.convertToItemsVariableReference(zenaVariableName, Optional.empty(), Optional.empty());
            } else if (this.isEventAttribute(zenaVariableName)) {
                String trimmedZenaVariableName = zenaVariableName.trim();
                ctmVarName = this.convertEventAttributeVariable(trimmedZenaVariableName);
            } else {
                ctmVarName = this.variablesChecker.isDependencyVariable(zenaVariableName.trim()) ? this.convertToLocalVariable(ctmVarName.replaceFirst("^DEPENDENCY\\.VARIABLE\\.", "")) : (this.isZenaBuiltInVariable(zenaVariableName) ? this.zenaBuiltInVariablesMapping.get(zenaVariableName) : this.convertToCtmVariableName(zenaVariableName));
            }
            if (!this.variablesChecker.isSupportedVariable(zenaVariableName) && this.job != null) {
                this.job.addMessage("WRN15031", this.job.getJobName(), this.job.getOriginalJobName(), zenaVariableName, ctmVarName);
            }
        }
        return ctmVarName;
    }

    private boolean isZenaBuiltInVariable(String zenaVariableName) {
        return this.zenaBuiltInVariablesMapping.containsKey(zenaVariableName);
    }

    private String convertEventAttributeVariable(String zenaVariableName) {
        String ctmEventVariable = this.convertToLocalVariable(zenaVariableName);
        boolean isSupportedEventVariable = UnsupportedZenaVariables.SUPPORTED_EVENT_VARIABLE_PATTERN.matcher(zenaVariableName).matches();
        if (isSupportedEventVariable) {
            return ctmEventVariable.toUpperCase();
        }
        return ctmEventVariable;
    }

    private boolean isEventAttribute(String zenaVariableName) {
        return zenaVariableName.startsWith("EVENT.ATTRIBUTE.");
    }

    public String convertToFolderLevelVariableName(String taskVariableName, ZenaJob job) {
        if (job.hasParent()) {
            return this.convertToFolderLevelVariableNameWithItemUID(taskVariableName);
        }
        return this.convertToLocalVariable(taskVariableName);
    }

    public String convertToCtmVariableName(String zenaVariableName) {
        return this.convertToCtmVariableName(zenaVariableName, this::convertToLocalVariable);
    }

    public String convertToFolderLevelVariableNameWithItemUID(String zenaVariableName) {
        String variableWithOutItemUid = this.convertToCtmVariableName(zenaVariableName, this::convertToLocalVariable);
        if (ZenaDefs.addZenaItemUidOnlyWhenNeeded(this.job.getRules()) && !this.smartFolderContainsVariable(variableWithOutItemUid)) {
            String jobName = this.job.getAlias();
            this.job.getSmartFolder().getVariablesMapping().setJobWithVariable(jobName, zenaVariableName);
            return variableWithOutItemUid;
        }
        return this.convertToCtmVariableName(zenaVariableName, variableName -> this.convertToFolderLevelVariableWithItemUID(this.job, (String)variableName));
    }

    private boolean smartFolderContainsVariable(String variableWithOutItemUid) {
        return this.job.getSmartFolder().getAutoedits().containsKey(variableWithOutItemUid);
    }

    private String convertToCtmVariableName(String zenaVariableName, UnaryOperator<String> variableNameConvertor) {
        String trimmedZenaVariableName = zenaVariableName.trim();
        return this.tryConvertingSystemVariable(trimmedZenaVariableName).orElseGet(() -> (String)variableNameConvertor.apply(trimmedZenaVariableName));
    }

    private Optional<String> tryConvertingSystemVariable(String variableName) {
        if (variableName.startsWith(SYSTEM_VARIABLE_PREFIX)) {
            String poolName = this.createPoolNameFromApplicationName(Optional.ofNullable(this.entitiesDefinitionsManager).map(EntitiesDefinitionsManager::getFolderHierarchy), this.entityProcessData);
            return Optional.ofNullable(this.convertToCtmPoolVariableName(variableName, poolName));
        }
        return Optional.empty();
    }

    public String createPoolNameFromApplicationName(Optional<ZenaFolderHierarchy> folderHierarchy, XmlElement element) {
        return element.findParent(parent -> parent.hasAttribute("FOLDER_ID")).map(definition -> definition.getAttribute("FOLDER_ID")).flatMap(folderId -> folderHierarchy.map(hierarchy -> hierarchy.getFolderPath((String)folderId)).flatMap(FolderPath::getApplication).map(v -> FieldValidation.instance().validateAndReturnFixedValue("APPLICATION_ZENA", v))).orElse("SYSTEM_VARIABLE");
    }

    private String convertToFolderLevelVariableWithItemUID(ZenaJob job, String variableName) {
        return "%%" + this.validateVariableName(this.addUidPrefix(this.shortenVariableName(variableName), job));
    }

    public String formatSmartVariable(String variableName) {
        return SMART_FOLDER_VARIABLE_PREFIX + variableName;
    }

    public String formatPoolVariable(String poolName, String variableName) {
        return String.format("%s\\\\%s\\%s", "%%", poolName, variableName);
    }

    private String addUidPrefix(String variableName, ZenaJob job) {
        return job.getItemUid() + "_" + variableName;
    }

    public String annotateSmartFolderVariableName(String variable, Optional<String> variableUid, Optional<String> itemUid) {
        if (this.itemVariablesHandler.isItemsVariable(variable)) {
            return this.itemVariablesHandler.convertToItemsVariableName(variable, variableUid, itemUid);
        }
        return this.formatSmartVariable(this.convertToCtmVariable(variable));
    }

    public String annotateSmartFolderVariableName(String variable) {
        return this.annotateSmartFolderVariableName(variable, Optional.empty(), Optional.empty());
    }

    public String annotateSystemVariableName(String variableName) {
        return this.tryConvertingSystemVariable(variableName.trim()).orElseGet(() -> this.annotateSystemVariableName(variableName, "SYSTEM_VARIABLE"));
    }

    public String annotateSystemVariableName(String variableName, String poolName) {
        return this.convertToCtmPoolVariableName(variableName, poolName);
    }

    private String convertToLocalVariable(String zenaVariableName) {
        return "%%" + this.convertToCtmVariable(zenaVariableName);
    }

    private void addGlobalVariableAction(String jobID, String varName) {
        Reporter.addGlobalAutoEditAction(this.job.getMessages(), (String)varName, (String)"", (String)jobID);
    }

    private String convertToCtmPoolVariableName(String variable, String poolName) {
        return this.formatPoolVariable(poolName, this.convertToCtmVariable(variable));
    }

    private String convertToCtmVariable(String variable) {
        return this.validateVariableName(this.shortenVariableName(variable));
    }

    public String validateVariableName(String variable) {
        return FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", variable, true, "VARIABLE", this.job == null ? null : this.job.getOriginalJobName(), this.job == null ? null : this.job.getMessages());
    }

    private String shortenVariableName(String variable) {
        return variable.replaceAll("^TASK.VARIABLE.", "").replaceAll("^PROCESS.VARIABLE.", "").replaceAll("^SYSTEM.VARIABLE.", "").replaceAll("^EVENT.ATTRIBUTE.", "").replaceAll("^ITEMS\\.(.*?)\\.VARIABLE\\.(.*)$", "$1_$2");
    }

    public XmlElement getEntityProcessData() {
        return this.entityProcessData;
    }

    public ZenaJob getJob() {
        return this.job;
    }

    public EntitiesDefinitionsManager getEntitiesDefinitionsManager() {
        return this.entitiesDefinitionsManager;
    }
}

