/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.ZenaDefs;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.utils.TaskEmailUtils;
import com.bmc.ctmconvert.zena.utils.ZenaXmlUtils;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ZenaVariablesConvertor {
    private final ZenaJob job;
    private final EntitiesDefinitionsManager entitiesDefinitionsManager;

    public ZenaVariablesConvertor(ZenaJob job, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        this.job = job;
        this.entitiesDefinitionsManager = entitiesDefinitionsManager;
    }

    public void convertVariables() {
        this.job.addAutoEdits("%%ZenaUID", this.job.getItemUidOrUid());
        Element taskVariables = null;
        Element processTaskVariables = null;
        if (this.job.isSmart()) {
            if (ZenaDefs.isOrderingJobRuleEnabled(this.job.getRules())) {
                this.job.addAutoEdits("%%$$OUT", "echo folder ended");
                this.job.addAutoEdits("%%$$OUTERR", "echo folder ended notok");
            }
            NodeList processChilds = this.job.entityDefinition.getChildNodes();
            for (int index = 0; index < processChilds.getLength(); ++index) {
                if (!processChilds.item(index).getNodeName().equals("VARIABLES")) continue;
                taskVariables = (Element)processChilds.item(index);
            }
            Element policies = (Element)this.job.entityDefinition.getElementsByTagName("POLICIES").item(0);
            if (policies != null) {
                processTaskVariables = (Element)policies.getElementsByTagName("VARIABLES").item(0);
            }
        } else {
            taskVariables = this.getVariables(this.job.entityDefinition);
            processTaskVariables = this.getVariables(this.job.entityProcessData);
        }
        this.convertVariablesFrom(taskVariables, processTaskVariables, "");
        this.convertNextSkippedTaskEmailVariables();
    }

    private void convertNextSkippedTaskEmailVariables() {
        TaskEmailUtils.getNextSkippedEmailTasks(this.job.entityProcessData, this.entitiesDefinitionsManager).forEach(skippedTaskEmailItem -> {
            XmlElement taskDefinition = ZenaXmlUtils.getTaskDefinitionFromItem(this.entitiesDefinitionsManager, skippedTaskEmailItem);
            String emailTaskUID = skippedTaskEmailItem.getAttribute("ITEM_UID");
            this.convertVariablesFrom(this.getVariables(taskDefinition.getElement()), this.getVariables(skippedTaskEmailItem.getElement()), emailTaskUID);
        });
    }

    private void convertVariablesFrom(Element taskVariables, Element processTaskVariables, String emailTaskItemUID) {
        if (taskVariables != null) {
            NodeList taskVariablesList = taskVariables.getElementsByTagName("VARIABLE");
            for (int i = 0; i < taskVariablesList.getLength(); ++i) {
                Element taskVariable = (Element)taskVariablesList.item(i);
                Element processTaskVariable = null;
                if (processTaskVariables != null) {
                    NodeList processTaskVariablesList = processTaskVariables.getElementsByTagName("VARIABLE");
                    for (int j = 0; j < processTaskVariablesList.getLength(); ++j) {
                        processTaskVariable = (Element)processTaskVariablesList.item(j);
                        if (taskVariable.getAttribute("UID").equals(processTaskVariable.getAttribute("UID"))) break;
                        processTaskVariable = null;
                    }
                }
                this.convertVariable(taskVariable, processTaskVariable, emailTaskItemUID);
            }
        }
    }

    private Element getVariables(Element entityDefinition) {
        XmlElement taskVariableXmlElement = XmlElement.ofNullable((Element)entityDefinition).getFirstChildElementByName("VARIABLES");
        return Optional.ofNullable(taskVariableXmlElement).map(XmlElement::getElement).orElse(null);
    }

    public void convertVariable(Element taskVariable, Element processTaskVariable, String emailTaskItemUID) {
        String variableName = this.convertVariableName(taskVariable, emailTaskItemUID);
        String variableValue = this.getVariableValueOrOverwrittenValue(taskVariable, processTaskVariable);
        if (this.job.hasParent()) {
            this.convertTaskVariable(taskVariable, emailTaskItemUID, variableName, variableValue);
        } else {
            this.job.addAutoEdits(variableName, variableValue);
        }
    }

    private void convertTaskVariable(Element taskVariable, String emailTaskItemUID, String smartVariableName, String variableValue) {
        String localVariableName = this.job.getZenaVariablesHandler().convertToCtmVariableName(emailTaskItemUID + this.getTaskVariableName(taskVariable));
        this.job.addAutoEdits(localVariableName, smartVariableName + ".");
        this.job.getSmartFolder().addAutoEdits(smartVariableName, variableValue);
    }

    private String convertVariableName(Element taskVariable, String eMailTaskItemUID) {
        return this.job.getZenaVariablesHandler().convertToFolderLevelVariableName(eMailTaskItemUID + this.getTaskVariableName(taskVariable), this.job);
    }

    private String getTaskVariableName(Element taskVariable) {
        return taskVariable.getAttribute("NAME");
    }

    private String getVariableValueOrOverwrittenValue(Element taskVariable, Element processTaskVariable) {
        String variableValueFromProcessDefinitionsOrTaskDefinitions = processTaskVariable == null ? taskVariable.getTextContent() : processTaskVariable.getTextContent();
        return this.job.getZenaVariablesHandler().annotateVariables(variableValueFromProcessDefinitionsOrTaskDefinitions);
    }
}

