/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.SchedulingConverter;
import com.bmc.ctmconvert.zena.ZenaCSVDefinitions;
import com.bmc.ctmconvert.zena.ZenaGlobals;
import java.io.File;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ZenaImporter
extends Importer {
    private String currentID = "";
    private final ImportEntryList entries;

    public ZenaImporter(ImportEntryList entries) {
        this.entries = entries;
    }

    public String getTitle() {
        return "Analyze Zena definitions";
    }

    public Progressable.ProgressStatus performImport() {
        this.cleanVendorData();
        try {
            String dataDirectory = ConversionEntitiesService.getCurrentProjectDataDirectory();
            int progressMax = 0;
            for (ImportEntry entry : this.entries) {
                progressMax += ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.size();
                File file = new File(dataDirectory + entry.getDestinationFileName());
                AttrHolderList definitions = new ZenaCSVDefinitions(file.toPath()).getDefinitions();
                progressMax += definitions.size();
                progressMax += ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.size();
            }
            this.setProgressMax(0L);
            this.setProgressMax(progressMax);
            int count = 0;
            block3: for (ImportEntry entry : this.entries) {
                this.currentID = entry.getID();
                File file = new File(dataDirectory + entry.getDestinationFileName());
                if (file.exists()) {
                    Pattern typeNamePattern = Pattern.compile("<([^\\s_]+)[_\\s]");
                    DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    HashMap<String, Document> tagTypeToDocument = new HashMap<String, Document>();
                    for (String string : ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.keySet()) {
                        Document output;
                        if (this.isStopped()) break;
                        File sourceFile = new File(dataDirectory + Globs.DIRSEP + ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.get(string));
                        if (sourceFile.exists()) {
                            output = documentBuilder.parse(sourceFile);
                            output.getDocumentElement().normalize();
                        } else {
                            output = documentBuilder.newDocument();
                            Element rootElement = output.createElement("DEFINITIONS");
                            output.appendChild(rootElement);
                        }
                        tagTypeToDocument.put(string, output);
                        this.setCurrentProgress(++count);
                    }
                    if (!this.isStopped()) {
                        AttrHolderList definitions = new ZenaCSVDefinitions(file.toPath()).getDefinitions();
                        for (IAttrHolder attr : definitions) {
                            Document destination;
                            if (this.isStopped()) break;
                            String textElement = attr.getAttr("DETAILS");
                            if (textElement == null) {
                                textElement = attr.getAttr("DETAILS".toLowerCase());
                            }
                            Optional<String> folderId = Optional.ofNullable(attr.getAttrIgnoreCase("FOLDERID"));
                            Optional<String> id = Optional.ofNullable(attr.getAttrIgnoreCase("ID"));
                            Optional<String> enabledFlag = Optional.ofNullable(attr.getAttrIgnoreCase("ENABLE_FLAG"));
                            Matcher matcher = typeNamePattern.matcher(textElement);
                            String type = "";
                            if (matcher.find()) {
                                type = matcher.group(1);
                            }
                            if ((destination = (Document)tagTypeToDocument.get(type)) == null) {
                                destination = (Document)tagTypeToDocument.get("OTHER");
                            }
                            Element newElement = destination.createElement("DEFINITION");
                            Document document = newElement.getOwnerDocument();
                            Node fragmentNode = documentBuilder.parse(new InputSource(new StringReader(textElement))).getDocumentElement();
                            Node namedItem = fragmentNode.getAttributes().getNamedItem("UID");
                            if (namedItem == null) continue;
                            newElement.setAttribute("UID", namedItem.getNodeValue());
                            folderId.ifPresent(fldId -> newElement.setAttribute("FOLDER_ID", (String)fldId));
                            id.ifPresent(idValue -> newElement.setAttribute("ID", (String)idValue));
                            enabledFlag.ifPresent(enableFlag -> newElement.setAttribute("ENABLE_FLAG", (String)enableFlag));
                            fragmentNode = document.importNode(fragmentNode, true);
                            newElement.appendChild(fragmentNode);
                            destination.getFirstChild().appendChild(newElement);
                            this.setCurrentProgress(++count);
                        }
                    }
                    if (this.isStopped()) continue;
                    for (String string : ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.keySet()) {
                        if (this.isStopped()) continue block3;
                        StreamResult result = new StreamResult(new File(dataDirectory + Globs.DIRSEP + ZenaGlobals.XML_TARGET_TAG_TYPES_TO_FILE_NAME.get(string)));
                        DOMSource source = new DOMSource((Node)tagTypeToDocument.get(string));
                        Transformer xformer = TransformerFactory.newInstance().newTransformer();
                        xformer.setOutputProperty("indent", "yes");
                        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                        xformer.transform(source, result);
                        this.setCurrentProgress(++count);
                    }
                    continue;
                }
                this.setStatus(entry.isMandatory() ? Progressable.ProgressStatus.ENDED_FAILURE : Progressable.ProgressStatus.ENDED_WITH_MESSAGE);
            }
            if (this.isStopped()) {
                this.setStatus(Progressable.ProgressStatus.ENDED_STOPED);
            } else {
                this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
            }
        }
        catch (Exception e) {
            ConversionLogger.getLogger().info(e.getMessage());
            this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
        }
        return this.getStatus();
    }

    public String getID() {
        return this.currentID;
    }

    private void cleanVendorData() {
        EntitiesDefinitionsManager.destroy();
        SchedulingConverter.destroy();
    }
}

