/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.zena.ZenaJob;
import java.util.Set;
import java.util.stream.Collectors;

public class ZenaCtmOrderJobConverter {
    private String getVariableFormat() {
        if (SettingsBooleanKeys.ZENA_CTMORDER_AS_EMBEDDED_SCRIPT.isEnabled()) {
            return " -%s %%%%%%%%%s %s";
        }
        return " -%s %%%%#%%%%#%s %s";
    }

    public String formatVariable(String dereferenceVarName, String value) {
        return String.format(this.getVariableFormat(), "VARIABLE", dereferenceVarName, value);
    }

    public void setJobAttributes(String ctmOrderCommand, ZenaJob job) {
        if (SettingsBooleanKeys.ZENA_CTMORDER_AS_EMBEDDED_SCRIPT.isEnabled()) {
            job.addAttribute("TASKTYPE", "Job");
            job.addAttribute("INSTREAM_JCL", ctmOrderCommand);
            job.addAttribute("USE_INSTREAM_JCL", "Y");
        } else {
            job.addAttribute("CMDLINE", ctmOrderCommand);
        }
    }

    public String appendJobVariables(Set<String> variableNames, ZenaJob job) {
        return variableNames.stream().map(variableName -> {
            String value = job.getAutoedits().get(variableName);
            String dereferenceVarName = GlobalFunctions.removeVariablePrefix((String)variableName);
            String variableValue = this.getCtmOrderVariableValue(value, dereferenceVarName);
            return this.formatVariable(dereferenceVarName, variableValue);
        }).collect(Collectors.joining());
    }

    public String getCtmOrderVariableValue(String value, String dereferenceVarName) {
        if (SettingsBooleanKeys.ZENA_CTMORDER_AS_EMBEDDED_SCRIPT.isEnabled()) {
            return "%" + dereferenceVarName + "%";
        }
        return value == null ? "" : value;
    }
}

