/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZenaActions {
    private Map<String, Collection<Agent>> agentListUidToAgents = new HashMap<String, Collection<Agent>>();
    private Map<String, Agent> agentUidToAgent = new HashMap<String, Agent>();
    private XmlElement agentsXmlElement;
    private XmlElement agentListXmlElement;
    private static String AGENTLIST = "AGENTLIST";
    private static String NAME = "NAME";
    private static String ID = "UID";
    private static String AGENT = "AGENT";
    private static String COMPUTER = "COMPUTER";
    private List<String> messages;

    public ZenaActions(XmlElement agentsXmlElement, XmlElement agentListXmlElement, ArrayList<String> messages) {
        this.agentsXmlElement = agentsXmlElement;
        this.agentListXmlElement = agentListXmlElement;
        this.messages = messages;
    }

    public Map<String, Collection<Agent>> getAgentsActions() {
        this.createAgentsMap();
        this.createAgentsListMap();
        return this.agentListUidToAgents;
    }

    private void createAgentsListMap() {
        XmlElement xmlElements = this.agentListXmlElement;
        List agentListsXmlElements = xmlElements.getAllDecnedElementByName(AGENTLIST);
        this.addToAgentListMap(agentListsXmlElements);
    }

    private void addToAgentListMap(List<XmlElement> agentListsXmlElements) {
        for (XmlElement agentListXmlElement : agentListsXmlElements) {
            List agentsXmlElements = agentListXmlElement.getAllDecnedElementByName(AGENT);
            String agentListName = agentListXmlElement.getAttribute(NAME);
            List<Agent> agentList = this.getAgents(agentsXmlElements, agentListName);
            this.addAgentList(agentListName, agentList);
        }
    }

    private List<Agent> getAgents(List<XmlElement> agentsXmlElements, String agentListName) {
        ArrayList<Agent> agentList = new ArrayList<Agent>();
        for (XmlElement agentElement : agentsXmlElements) {
            Agent agent = this.agentUidToAgent.get(agentElement.getAttribute(ID));
            if (agent != null) {
                agentList.add(agent);
                continue;
            }
            String validateAgentListName = FieldValidation.instance().validateAndReturnFixedValue("NODEGRP", agentListName);
            String validateAgentID = FieldValidation.instance().validateAndReturnFixedValue("NODEID", agentElement.getAttribute(ID));
            Reporter.addMessage(this.messages, (String)"WRN15033", (String)validateAgentListName, (String[])new String[]{validateAgentListName, validateAgentID});
        }
        return agentList;
    }

    private void createAgentsMap() {
        XmlElement agentFileElements = this.agentsXmlElement;
        List agentElements = agentFileElements.getAllDecnedElementByName(AGENT);
        for (XmlElement agent : agentElements) {
            this.addAgent(new Agent(this, agent));
        }
    }

    public void addAgent(Agent agent) {
        this.agentUidToAgent.put(agent.getID(), agent);
    }

    public void addAgentList(String agentListName, List<Agent> agents) {
        this.agentListUidToAgents.put(agentListName, agents);
    }

    public class Agent {
        private Map<String, String> attributes;
        private XmlElement element;

        public Agent(ZenaActions this$0, XmlElement xmlElement) {
            this.attributes = xmlElement.getAttributes();
            this.element = xmlElement;
        }

        public String getID() {
            return this.attributes.get(ID);
        }

        public String getComputerName() {
            return this.attributes.get(COMPUTER);
        }

        public String getName() {
            return this.attributes.get(NAME);
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public XmlElement getElement() {
            return this.element;
        }
    }
}

