/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.exceptions.RBCIllegalValueException;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import com.bmc.ctmconvert.zena.scheduling.ZenaRBC;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchedulingConverter {
    private static SchedulingConverter instance;
    private final AtomicInteger uniqueId = new AtomicInteger();
    private final Map<String, SchedulingAttributes> calendarAttributes;
    private final Map<String, SchedulingAttributes> ruleAttributes;
    private final Map<String, RBC> rbcToCalendarFile;
    Pattern startEndPattern = Pattern.compile("(\\d{4})\\.(\\d{2})\\.(\\d{2})");
    public static final String CALENDAR = "calendar";

    public static SchedulingConverter instance() {
        if (instance == null) {
            instance = new SchedulingConverter();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public SchedulingAttributes getSchedulingAttributes(String calendarID) {
        SchedulingAttributes toRet = new SchedulingAttributes();
        try {
            Element calendar = EntitiesDefinitionsManager.instance().getElementByID(calendarID);
            toRet = this.calendarAttributes.get(calendar.getAttribute("UID"));
            if (toRet == null) {
                List<Element> datelistList;
                toRet = new SchedulingAttributes();
                List<Element> rules = this.getCalendarSchedulingElements(calendar, "RULE");
                for (Element rule : rules) {
                    String ID = String.format("%s-%s", calendar.getAttribute("UID"), rule.getAttribute("NAME"));
                    if (!this.ruleAttributes.containsKey(ID)) {
                        this.zenaRuleToRbc(rule, calendarID, rules.size() == 1 ? calendar.getAttribute("NAME") : null);
                    }
                    if (!this.ruleAttributes.containsKey(ID)) continue;
                    SchedulingAttributes ruleAttr = this.ruleAttributes.get(ID);
                    toRet.addAllRbcs(ruleAttr.getRbcs());
                    Map<String, List<String[]>> messages = ruleAttr.getMessages();
                    for (String message : messages.keySet()) {
                        for (String[] params : messages.get(message)) {
                            toRet.addMessage(message, params);
                        }
                    }
                }
                List<Element> resolutionList = this.getCalendarSchedulingElements(calendar, "RESOLUTION");
                if (!resolutionList.isEmpty()) {
                    StringBuilder resolutionDefinitions = new StringBuilder();
                    for (Element resolution : resolutionList) {
                        resolutionDefinitions.append(", " + resolution.getAttribute("NAME"));
                    }
                    toRet.addMessage("WRN15005", resolutionList.size() > 1 ? "s" : "", resolutionDefinitions.toString().replaceFirst(", ", ""));
                }
                if (!(datelistList = this.getCalendarSchedulingElements(calendar, "DATELIST")).isEmpty()) {
                    toRet.addMessage("WRN15019", calendar.getAttribute("NAME"));
                }
                this.calendarAttributes.put(calendar.getAttribute("UID"), toRet);
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return toRet;
    }

    private SchedulingConverter() {
        this.calendarAttributes = new HashMap<String, SchedulingAttributes>();
        this.ruleAttributes = new HashMap<String, SchedulingAttributes>();
        this.rbcToCalendarFile = new LinkedHashMap<String, RBC>();
        this.loadSchedulingData();
        this.writeRbcsToFile();
    }

    public static Properties getDefaultRbc(SchedEntity.TYPE type) {
        Properties toRet = new Properties();
        if (type.equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
            toRet.setProperty("NAME", "EMPTY_RBC");
        } else {
            toRet.setProperty("NAME", "*");
        }
        return toRet;
    }

    private void loadSchedulingData() {
        Document calendarsDocument = EntitiesDefinitionsManager.instance().getDocumentByType("CALENDAR");
        NodeList calendars = calendarsDocument.getElementsByTagName("CALENDAR");
        for (int index = 0; index < calendars.getLength(); ++index) {
            Element calendar = (Element)calendars.item(index);
            List<Element> rules = this.getCalendarSchedulingElements(calendar, "RULE");
            for (Element rule : rules) {
                this.zenaRuleToRbc(rule, calendar.getAttribute("UID"), rules.size() == 1 ? calendar.getAttribute("NAME") : null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void zenaRuleToRbc(Element rule, String calendarID, String calendarName) {
        String setValue;
        String setType;
        String subsetType;
        boolean exclude;
        int offset;
        boolean offsetHandeled;
        ZenaRBC rbc;
        SchedulingAttributes attributes;
        String ruleID;
        String ruleName;
        block85: {
            ruleName = rule.getAttribute("NAME");
            ruleID = String.format("%s-%s", calendarID, ruleName);
            attributes = new SchedulingAttributes();
            rbc = new ZenaRBC(this.uniqueId);
            rbc.setFirstDayOfTheWeek(RBC.stringToWEEKDAY((String)RuleManager.instance.getCurrentRules().getStringRule("Zena rules", new String[]{"FIRST_DAY_OF_WEEK"})));
            String startdate = rule.getAttribute("STARTDATE");
            String enddate = rule.getAttribute("ENDDATE");
            Matcher matcher = this.startEndPattern.matcher(startdate);
            if (matcher.matches()) {
                rbc.setActive_from(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
            if ((matcher = this.startEndPattern.matcher(enddate)).matches()) {
                int year = Integer.parseInt(matcher.group(1));
                int month = Integer.parseInt(matcher.group(2));
                int date = Integer.parseInt(matcher.group(3));
                if (RuleManager.instance().getCurrentRules().getBooleanRule("Zena rules", new String[]{"IGNORE_DEPRECATED_SCHEDULING"}).booleanValue()) {
                    Date today = new Date();
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(year, month - 1, date);
                    Date ruleEndDate = calendar.getTime();
                    if (ruleEndDate.before(today)) {
                        attributes.addMessage("INF15002", ruleName, EntitiesDefinitionsManager.instance().getElementByID(calendarID).getAttribute("NAME"));
                        this.ruleAttributes.put(ruleID, attributes);
                        return;
                    }
                }
                rbc.setActive_till(year, month, date);
            }
            offsetHandeled = false;
            try {
                offset = Integer.parseInt(rule.getAttribute("OFFSET"));
            }
            catch (NumberFormatException e1) {
                offset = 0;
            }
            if (offset == 0) {
                offsetHandeled = true;
            }
            exclude = rule.getAttribute("EXCLUDE").equalsIgnoreCase("yes");
            String occurrence = rule.getAttribute("OCCURRENCE").toLowerCase();
            Element subset = (Element)rule.getElementsByTagName("SUBSET").item(0);
            subsetType = subset.getAttribute("TYPE").toLowerCase();
            String subsetValue = subset.getAttribute("VALUE").toLowerCase();
            if (subsetType.equals(CALENDAR)) {
                subsetValue = subset.getAttribute("UID");
            }
            Element set = (Element)rule.getElementsByTagName("SET").item(0);
            setType = set.getAttribute("TYPE").toLowerCase();
            setValue = set.getAttribute("VALUE");
            if (setType.equals(CALENDAR)) {
                setValue = set.getAttribute("UID");
            } else if (setValue != null && !setValue.isEmpty()) {
                setValue = setValue.replaceAll("[^\\d,]+", "");
            }
            if (subsetType.equals("day") && !setType.equals(CALENDAR)) {
                try {
                    if (occurrence.equals("every")) {
                        rbc.addAllDays();
                    } else if (occurrence.equals("last")) {
                        rbc.addDay(RBC.DAY_TYPE.DAY_FROM_END, 1);
                    } else {
                        if (occurrence.contains("every,")) {
                            attributes.addMessage("INF15004", occurrence, EntitiesDefinitionsManager.instance().getElementByID(calendarID).getAttribute("NAME"));
                            occurrence = occurrence.replace("every,", "");
                        }
                        if ((occurrence = occurrence.replaceAll("[^\\d,]+", "")).matches("(\\d+,?)+")) {
                            void var23_32;
                            String[] stringArray = occurrence.split(",");
                            int n = stringArray.length;
                            boolean bl = false;
                            while (var23_32 < n) {
                                String day = stringArray[var23_32];
                                rbc.addDay(Integer.parseInt(day) + offset);
                                ++var23_32;
                            }
                            offsetHandeled = true;
                        }
                    }
                }
                catch (RBCIllegalValueException e) {
                    attributes.addMessage("WRN15006", occurrence);
                }
            } else if (subsetType.equals("weekdays")) {
                if (setType.equals("year") || setType.equals("yearweek")) {
                    String[] weekdays;
                    for (String weekday : weekdays = subsetValue.split(",")) {
                        rbc.addWeekDay(RBC.stringToWEEKDAY((String)weekday));
                    }
                } else if (setType.equals("month") || setType.equals("monthweek")) {
                    try {
                        String weeksStr = setType.equals("month") ? occurrence : setValue;
                        weeksStr = weeksStr.replaceAll("[^\\d,]+", "");
                        if (weeksStr.matches("(\\d+,?)+")) {
                            String[] weeksArray = weeksStr.split(",");
                            int[] nArray = new int[weeksArray.length];
                            for (int index = 0; index < weeksArray.length; ++index) {
                                nArray[index] = Integer.parseInt(weeksArray[index]);
                            }
                            String[] weekdaysArray = subsetValue.split(",");
                            for (int week : nArray) {
                                for (String day : weekdaysArray) {
                                    RBC.WEEKDAYS weekday = RBC.stringToWEEKDAY((String)day);
                                    if (weekday != null) {
                                        rbc.addDayInWeek(week, weekday);
                                        continue;
                                    }
                                    attributes.addMessage("WRN15002", subsetValue);
                                }
                            }
                            break block85;
                        }
                        if (occurrence.equals("last")) {
                            String[] weekdaysArray;
                            rbc.setDays_and_or(RBC.DAYS_AND_OR.AND);
                            for (String day : weekdaysArray = subsetValue.split(",")) {
                                RBC.WEEKDAYS weekday = RBC.stringToWEEKDAY((String)day);
                                weekday = RBC.WEEKDAYS.values()[(weekday.ordinal() + 70 + offset) % 7];
                                rbc.addWeekDay(weekday);
                            }
                            int n = offset >= 0 ? 1 : Math.abs(offset) + 1;
                            int end = offset = 7 - offset;
                            for (int index = n; index <= end; ++index) {
                                rbc.addDay(RBC.DAY_TYPE.DAY_FROM_END, index);
                            }
                            offsetHandeled = true;
                            break block85;
                        }
                        attributes.addMessage("WRN15006", occurrence);
                    }
                    catch (RBCIllegalValueException e) {
                        attributes.addMessage("WRN15002", subsetValue);
                    }
                } else {
                    attributes.addMessage("WRN15003", setValue);
                }
            } else if (subsetType.equals(CALENDAR)) {
                if (!this.calendarAttributes.containsKey(subsetValue)) {
                    this.calendarAttributes.put(subsetValue, this.getSchedulingAttributes(subsetValue));
                }
                SchedulingAttributes existingCalendar = this.calendarAttributes.get(subsetValue);
                if (!occurrence.equals("every")) {
                    offsetHandeled = true;
                    String origName = calendarName != null ? calendarName : ruleName;
                    attributes.addMessage("WRN15015", occurrence, origName);
                    rbc.setName(origName);
                    this.rbcToCalendarFile.putIfAbsent(rbc.getRBC().getProperty("NAME"), rbc);
                    attributes.addRbc(rbc.getRBC());
                } else if (setType.equals("year")) {
                    if (existingCalendar != null) {
                        if (exclude) {
                            for (Properties properties : existingCalendar.getRbcs()) {
                                Properties newRbc = new Properties();
                                for (String key : properties.stringPropertyNames()) {
                                    newRbc.setProperty(key, properties.getProperty(key));
                                }
                                Object name = properties.getProperty("NAME");
                                name = ((String)name).startsWith("!") ? ((String)name).substring(1) : FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", "!" + (String)name);
                                newRbc.setProperty("NAME", (String)name);
                                attributes.addRbc(newRbc);
                            }
                        } else {
                            attributes.addAllRbcs(existingCalendar.getRbcs());
                        }
                        String[] messages = existingCalendar.getMessages();
                        for (String msgID : messages.keySet()) {
                            for (String[] params : (List)messages.get(msgID)) {
                                attributes.addMessage(msgID, params);
                            }
                        }
                    } else {
                        attributes.addMessage("WRN15007", subsetValue);
                    }
                } else if (setType.equals("month")) {
                    rbc.setDayscal(subsetValue);
                    if (occurrence.matches("(\\d+,?)+")) {
                        for (String day : occurrence.split(",")) {
                            try {
                                rbc.addDay(Integer.parseInt(day));
                            }
                            catch (RBCIllegalValueException e) {
                                attributes.addMessage("WRN15006", occurrence);
                            }
                        }
                    }
                }
            } else if (!subsetType.equals("day")) {
                attributes.addMessage("WRN15008", subsetType);
            }
        }
        Pattern intPattern = Pattern.compile("(\\d+)\\S*");
        String[] months = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        switch (setType) {
            case "yearweek": {
                String[] weeks = setValue.split(",");
                boolean allWeeks = true;
                for (int week = 1; week <= weeks.length; ++week) {
                    Matcher intMatch = intPattern.matcher(weeks[week - 1]);
                    if (!intMatch.matches() || intMatch.group(1).equals(String.valueOf(week))) continue;
                    allWeeks = false;
                    break;
                }
                if (allWeeks) break;
                attributes.addMessage("WRN15004", setValue);
                break;
            }
            case "month": {
                months = setValue.split(",");
                break;
            }
            case "calendar": {
                attributes.addMessage("WRN15009", setType);
                break;
            }
        }
        for (String month : months) {
            rbc.addMonth(RBC.MONTHS.values()[Integer.parseInt(month) - 1]);
        }
        if (!subsetType.equals(CALENDAR) && !setType.equals(CALENDAR)) {
            rbc.setLevel(RBC.LEVEL.CONTROL_M);
            try {
                rbc.setMaxwait(RuleManager.instance.getCurrentRules().getIntegerRule("Zena rules", new String[]{"MAXWAIT"}));
            }
            catch (RBCIllegalValueException rBCIllegalValueException) {
                // empty catch block
            }
            String string = calendarName != null ? calendarName : ruleName;
            rbc.setName(string);
            int uniquenessID = 0;
            String rbcName = rbc.getRBC().getProperty("NAME");
            while (this.rbcToCalendarFile.containsKey(rbcName) && !this.rbcToCalendarFile.get(rbcName).schedulingEquals((Object)rbc)) {
                rbc.setUniquenessID(++uniquenessID);
                rbcName = rbc.getRBC().getProperty("NAME");
            }
            if (!this.rbcToCalendarFile.containsKey(rbcName)) {
                this.rbcToCalendarFile.put(rbcName, rbc);
            }
            attributes.addRbc(this.rbcToCalendarFile.get(rbcName).getRBC(exclude));
            if (rbc.isWeekdaysTruncated()) {
                attributes.addMessage("WRN15038", string, rbcName);
            }
            if (rbc.isRenamed()) {
                attributes.addMessage("INF15003", "Rule Based Calendar name", "(Zena RULE)", string, rbcName);
            } else {
                if (rbc.isTruncated()) {
                    attributes.addMessage("INF0013", "Rule Based Calendar name", "(Zena RULE)", string, rbcName);
                }
                if (rbc.isContainsInvalidCharacters()) {
                    attributes.addMessage("INF0014", "Rule Based Calendar name", "(Zena RULE)", string, rbcName);
                }
            }
        }
        if (!offsetHandeled) {
            attributes.addMessage("WRN15001", String.valueOf(offset), EntitiesDefinitionsManager.instance().getElementByID(calendarID).getAttribute("NAME"));
        }
        this.ruleAttributes.put(ruleID, attributes);
    }

    private List<Element> getCalendarSchedulingElements(Element calendar, String type) {
        ArrayList<Element> toRet = new ArrayList<Element>();
        NodeList rules = calendar.getElementsByTagName(type);
        for (int index = 0; index < rules.getLength(); ++index) {
            toRet.add((Element)rules.item(index));
        }
        return toRet;
    }

    private void writeRbcsToFile() {
        try (DefCalFile calOutFile = DefCalFile.createDefCalFile();){
            for (RBC rbc : this.rbcToCalendarFile.values()) {
                calOutFile.writeRBC(rbc.getRBCForCalendarFile());
            }
        }
        catch (IOException e1) {
            ExceptionHandler.writeToExceptionFile((Exception)e1);
        }
    }

    public static class SchedulingAttributes {
        private final Map<String, List<String[]>> messages = new HashMap<String, List<String[]>>();
        private final List<Properties> rbcs = new ArrayList<Properties>();

        public void addRbc(Properties rbc) {
            if (!this.rbcs.contains(rbc)) {
                this.rbcs.add(rbc);
            }
        }

        public void addAllRbcs(List<Properties> rbcs) {
            for (Properties rbc : rbcs) {
                this.addRbc(rbc);
            }
        }

        public List<Properties> getRbcs() {
            return this.rbcs;
        }

        public void addMessage(String msgID, String ... params) {
            List<String[]> paramsList = this.messages.get(msgID);
            if (paramsList == null) {
                paramsList = new ArrayList<String[]>();
            }
            paramsList.add(params);
            this.messages.put(msgID, paramsList);
        }

        public Map<String, List<String[]>> getMessages() {
            return this.messages;
        }
    }
}

