/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena;

import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.common.CliParams;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.dataimport.DynamicDataImportPanel;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.fileimporter.FIleImporter;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.zena.ZenaImporter;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CliImporterZena
extends CliImporter {
    private ImportEntryList entries;
    private ZenaImporter importer;
    private FIleImporter fileImporter;

    public CliImporterZena(ImportEntryList entries, ZenaImporter importer, FIleImporter fileImporter) {
        this.entries = entries;
        this.importer = importer;
        this.fileImporter = fileImporter;
        this.checkParamsValidiy();
    }

    public FlowGlobals.COMPLETION_MODE doImport(String destinationFolderString) {
        String agentsFilePath = CliParams.instance().get("AGENTS");
        String definitionsFilePath = CliParams.instance().get("DEFINITIONS");
        Path destinationFolderPath = Paths.get(destinationFolderString, new String[0]);
        this.fileImporter.setTargetDirPath(destinationFolderPath);
        for (ImportEntry importEntry : this.entries) {
            if (importEntry.getID().equals("AGENTS")) {
                importEntry.setSourceFullName(agentsFilePath);
                this.fileImporter.setEntry(importEntry);
                this.fileImporter.performImport();
            }
            if (!importEntry.getID().equals("DEFINITIONS")) continue;
            importEntry.setSourceFullName(definitionsFilePath);
            this.fileImporter.setEntry(importEntry);
            this.fileImporter.performImport();
        }
        this.importer.performImport();
        Progressable.ProgressStatus importerStatus = this.importer.getStatus();
        return DynamicDataImportPanel.getCompletionMode((Progressable.ProgressStatus)importerStatus);
    }

    public void checkParamsValidiy() {
        BaseFieldValidator datasourceValidator = new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH);
        if (!datasourceValidator.isValid(CliParams.instance().get("AGENTS"))) {
            ProcessAlertsManager.instance().addMessage("AGENTS: " + datasourceValidator.getErrorMessage());
        }
        if (!datasourceValidator.isValid(CliParams.instance().get("DEFINITIONS"))) {
            ProcessAlertsManager.instance().addMessage("DEFINITIONS: " + datasourceValidator.getErrorMessage());
        }
    }
}

