/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.excelUtils;

import com.bmc.ctmconvert.excelUtils.Colors;
import java.awt.Color;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002J\u001c\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J-\u0010&\u001a\u00020'*\u00020\"2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0(\"\u00020%2\b\b\u0002\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J1\u0010&\u001a\u00020'\"\b\b\u0000\u0010,*\u00020\"*\u0002H,2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\b\b\u0002\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010-J\u001a\u0010.\u001a\u00020/*\u00020'2\u000e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%01J\u001c\u0010.\u001a\u00020/*\u00020'2\u0006\u00102\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u00010%J\u001a\u0010.\u001a\u00020/*\u00020'2\u0006\u00102\u001a\u00020*2\u0006\u00103\u001a\u000204J\u0012\u00105\u001a\u00020\u001a*\u00020/2\u0006\u00106\u001a\u00020\u001fJ&\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020/2\u0006\u0010!\u001a\u00020\"2\f\u00109\u001a\b\u0012\u0004\u0012\u00020%01H\u0002J\u0010\u0010:\u001a\u00020\u001a2\u0006\u00108\u001a\u00020/H\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006;"}, d2={"Lcom/bmc/ctmconvert/excelUtils/ExcelFile;", "", "<init>", "()V", "workbook", "Lorg/apache/poi/xssf/usermodel/XSSFWorkbook;", "getWorkbook", "()Lorg/apache/poi/xssf/usermodel/XSSFWorkbook;", "defaultCellStyle", "Lorg/apache/poi/xssf/usermodel/XSSFCellStyle;", "kotlin.jvm.PlatformType", "getDefaultCellStyle", "()Lorg/apache/poi/xssf/usermodel/XSSFCellStyle;", "Lorg/apache/poi/xssf/usermodel/XSSFCellStyle;", "blueCellStyle", "getBlueCellStyle", "boldCellStyle", "getBoldCellStyle", "blueFont", "Lorg/apache/poi/xssf/usermodel/XSSFFont;", "getBlueFont", "()Lorg/apache/poi/xssf/usermodel/XSSFFont;", "createBlueFont", "boldFont", "Lorg/apache/poi/ss/usermodel/Font;", "writeExcelFile", "", "filePath", "Ljava/nio/file/Path;", "toXssfColor", "Lorg/apache/poi/xssf/usermodel/XSSFColor;", "Ljava/awt/Color;", "createHeader", "sheet", "Lorg/apache/poi/ss/usermodel/Sheet;", "headerColumns", "", "", "addHeaderRow", "Lorg/apache/poi/ss/usermodel/Row;", "", "rowIndex", "", "(Lorg/apache/poi/ss/usermodel/Sheet;[Ljava/lang/String;I)Lorg/apache/poi/ss/usermodel/Row;", "T", "(Lorg/apache/poi/ss/usermodel/Sheet;Ljava/util/Collection;I)Lorg/apache/poi/ss/usermodel/Row;", "createReportCell", "Lorg/apache/poi/ss/usermodel/Cell;", "value", "Lkotlin/collections/IndexedValue;", "columnIndex", "cellContent", "Lorg/apache/poi/xssf/usermodel/XSSFRichTextString;", "setFillForegroundColor", "color", "setHeaderCellStyle", "cell", "cellValueWithIndex", "setSubTitleCellStyle", "Common"})
@SourceDebugExtension(value={"SMAP\nExcelFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExcelFile.kt\ncom/bmc/ctmconvert/excelUtils/ExcelFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1#2:127\n1863#3,2:128\n*S KotlinDebug\n*F\n+ 1 ExcelFile.kt\ncom/bmc/ctmconvert/excelUtils/ExcelFile\n*L\n56#1:128,2\n*E\n"})
public class ExcelFile {
    @NotNull
    private final XSSFWorkbook workbook = new XSSFWorkbook();
    private final XSSFCellStyle defaultCellStyle;
    @NotNull
    private final XSSFCellStyle blueCellStyle;
    @NotNull
    private final XSSFCellStyle boldCellStyle;
    @NotNull
    private final XSSFFont blueFont;

    /*
     * WARNING - void declaration
     */
    public ExcelFile() {
        XSSFCellStyle it;
        void it2;
        XSSFCellStyle xSSFCellStyle;
        XSSFCellStyle xSSFCellStyle2 = xSSFCellStyle = this.workbook.createCellStyle();
        ExcelFile excelFile = this;
        boolean $i$a$-also-ExcelFile$defaultCellStyle$22 = false;
        it2.setWrapText(true);
        excelFile.defaultCellStyle = xSSFCellStyle;
        XSSFCellStyle $i$a$-also-ExcelFile$defaultCellStyle$22 = xSSFCellStyle2 = this.defaultCellStyle.copy();
        excelFile = this;
        boolean bl = false;
        it.setFont((Font)this.createBlueFont());
        XSSFCellStyle xSSFCellStyle3 = xSSFCellStyle2;
        Intrinsics.checkNotNullExpressionValue((Object)xSSFCellStyle3, (String)"also(...)");
        excelFile.blueCellStyle = xSSFCellStyle3;
        it = xSSFCellStyle2 = this.defaultCellStyle.copy();
        excelFile = this;
        boolean bl2 = false;
        it.setFont(this.boldFont());
        XSSFCellStyle xSSFCellStyle4 = xSSFCellStyle2;
        Intrinsics.checkNotNullExpressionValue((Object)xSSFCellStyle4, (String)"also(...)");
        excelFile.boldCellStyle = xSSFCellStyle4;
        it = xSSFCellStyle2 = this.workbook.createFont();
        excelFile = this;
        boolean bl3 = false;
        it.setColor(IndexedColors.BLUE.getIndex());
        XSSFCellStyle xSSFCellStyle5 = xSSFCellStyle2;
        Intrinsics.checkNotNullExpressionValue((Object)xSSFCellStyle5, (String)"also(...)");
        excelFile.blueFont = xSSFCellStyle5;
    }

    @NotNull
    public final XSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public final XSSFCellStyle getDefaultCellStyle() {
        return this.defaultCellStyle;
    }

    @NotNull
    public final XSSFCellStyle getBlueCellStyle() {
        return this.blueCellStyle;
    }

    @NotNull
    public final XSSFCellStyle getBoldCellStyle() {
        return this.boldCellStyle;
    }

    @NotNull
    public final XSSFFont getBlueFont() {
        return this.blueFont;
    }

    private final XSSFFont createBlueFont() {
        XSSFFont xSSFFont;
        XSSFFont it = xSSFFont = this.workbook.createFont();
        boolean bl = false;
        it.setColor(this.toXssfColor(Colors.INSTANCE.getBlue()));
        XSSFFont xSSFFont2 = xSSFFont;
        Intrinsics.checkNotNullExpressionValue((Object)xSSFFont2, (String)"also(...)");
        return xSSFFont2;
    }

    private final Font boldFont() {
        XSSFFont xSSFFont;
        XSSFFont it = xSSFFont = this.workbook.createFont();
        boolean bl = false;
        it.setBold(true);
        XSSFFont xSSFFont2 = xSSFFont;
        Intrinsics.checkNotNullExpressionValue((Object)xSSFFont2, (String)"also(...)");
        return (Font)xSSFFont2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeExcelFile(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(filePath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            this.workbook.write(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final XSSFColor toXssfColor(Color $this$toXssfColor) {
        byte[] byArray = new byte[]{(byte)$this$toXssfColor.getRed(), (byte)$this$toXssfColor.getGreen(), (byte)$this$toXssfColor.getBlue()};
        return new XSSFColor(byArray, this.workbook.getStylesSource().getIndexedColors());
    }

    public final void createHeader(@NotNull Sheet sheet, @NotNull Collection<String> headerColumns) {
        Intrinsics.checkNotNullParameter((Object)sheet, (String)"sheet");
        Intrinsics.checkNotNullParameter(headerColumns, (String)"headerColumns");
        this.addHeaderRow(sheet, headerColumns, 0);
        sheet.createFreezePane(0, 1);
    }

    @NotNull
    public final Row addHeaderRow(@NotNull Sheet $this$addHeaderRow, @NotNull String[] headerColumns, int rowIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$addHeaderRow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)headerColumns, (String)"headerColumns");
        return this.addHeaderRow($this$addHeaderRow, ArraysKt.toList((Object[])headerColumns), rowIndex);
    }

    public static /* synthetic */ Row addHeaderRow$default(ExcelFile excelFile, Sheet sheet, String[] stringArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addHeaderRow");
        }
        if ((n2 & 2) != 0) {
            n = sheet.getLastRowNum() + 1;
        }
        return excelFile.addHeaderRow(sheet, stringArray, n);
    }

    @NotNull
    public final <T extends Sheet> Row addHeaderRow(@NotNull T $this$addHeaderRow, @NotNull Collection<String> headerColumns, int rowIndex) {
        Row row;
        Intrinsics.checkNotNullParameter($this$addHeaderRow, (String)"<this>");
        Intrinsics.checkNotNullParameter(headerColumns, (String)"headerColumns");
        Row headerRow = row = $this$addHeaderRow.createRow(rowIndex);
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)headerColumns);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue it = (IndexedValue)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)headerRow);
            this.setHeaderCellStyle(this.createReportCell(headerRow, (IndexedValue<String>)it), $this$addHeaderRow, (IndexedValue<String>)it);
        }
        Row row2 = row;
        Intrinsics.checkNotNullExpressionValue((Object)row2, (String)"also(...)");
        return row2;
    }

    public static /* synthetic */ Row addHeaderRow$default(ExcelFile excelFile, Sheet sheet, Collection collection, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addHeaderRow");
        }
        if ((n2 & 2) != 0) {
            n = sheet.getLastRowNum() + 1;
        }
        return excelFile.addHeaderRow(sheet, collection, n);
    }

    @NotNull
    public final Cell createReportCell(@NotNull Row $this$createReportCell, @NotNull IndexedValue<String> value) {
        Intrinsics.checkNotNullParameter((Object)$this$createReportCell, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.createReportCell($this$createReportCell, value.getIndex(), (String)value.getValue());
    }

    @NotNull
    public final Cell createReportCell(@NotNull Row $this$createReportCell, int columnIndex, @Nullable String cellContent) {
        Intrinsics.checkNotNullParameter((Object)$this$createReportCell, (String)"<this>");
        Cell it = $this$createReportCell.createCell(columnIndex);
        boolean bl = false;
        it.setCellStyle((CellStyle)this.defaultCellStyle);
        String string = cellContent;
        if (string == null) {
            string = "";
        }
        it.setCellValue(StringsKt.take((String)string, (int)30000));
        Intrinsics.checkNotNull((Object)it);
        return it;
    }

    @NotNull
    public final Cell createReportCell(@NotNull Row $this$createReportCell, int columnIndex, @NotNull XSSFRichTextString cellContent) {
        Intrinsics.checkNotNullParameter((Object)$this$createReportCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cellContent, (String)"cellContent");
        Cell it = $this$createReportCell.createCell(columnIndex);
        boolean bl = false;
        it.setCellStyle((CellStyle)this.defaultCellStyle);
        it.setCellValue((RichTextString)cellContent);
        Intrinsics.checkNotNull((Object)it);
        return it;
    }

    public final void setFillForegroundColor(@NotNull Cell $this$setFillForegroundColor, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)$this$setFillForegroundColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        CellStyle cellStyle = $this$setFillForegroundColor.getCellStyle();
        if (cellStyle instanceof XSSFCellStyle) {
            ((XSSFCellStyle)cellStyle).setFillForegroundColor(this.toXssfColor(color));
        }
    }

    private final void setHeaderCellStyle(Cell cell, Sheet sheet, IndexedValue<String> cellValueWithIndex) {
        XSSFCellStyle headerCellStyle = this.workbook.createCellStyle();
        headerCellStyle.setFont(this.boldFont());
        cell.setCellStyle((CellStyle)headerCellStyle);
        this.setFillForegroundColor(cell, Colors.INSTANCE.getHeaderColor());
        cell.getCellStyle().setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell.getCellStyle().setBorderBottom(BorderStyle.THIN);
        cell.getCellStyle().setBorderTop(BorderStyle.THIN);
        cell.getCellStyle().setBorderLeft(BorderStyle.THIN);
        cell.getCellStyle().setBorderRight(BorderStyle.THIN);
        sheet.setColumnWidth(cellValueWithIndex.getIndex(), Math.max((((String)cellValueWithIndex.getValue()).length() + 10) * 256, sheet.getColumnWidth(cellValueWithIndex.getIndex())));
    }

    protected final void setSubTitleCellStyle(@NotNull Cell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        XSSFCellStyle headerCellStyle = this.workbook.createCellStyle();
        cell.setCellStyle((CellStyle)headerCellStyle);
        this.setFillForegroundColor(cell, Colors.INSTANCE.getLightBlue());
        cell.getCellStyle().setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell.getCellStyle().setAlignment(HorizontalAlignment.CENTER);
    }
}

