/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.databaseCommon;

import com.bmc.ctmconvert.databaseCommon.DatabaseConnection;
import com.bmc.ctmconvert.databaseCommon.DatabaseType;
import com.bmc.ctmconvert.databaseCommon.EmDatabaseParameters;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0006\u0010\u000b\u001a\u00020\u0001\u001a.\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a.\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"buildOracleConnection", "Lcom/bmc/ctmconvert/databaseCommon/DatabaseConnection;", "hostName", "", "databaseName", "user", "password", "port", "buildConnection", "emDatabaseParameters", "Lcom/bmc/ctmconvert/databaseCommon/EmDatabaseParameters;", "buildH2Connection", "buildMssqlConnection", "buildPostgresConnection", "appendPort", "Common"})
public final class DatabaseConnectionKt {
    @NotNull
    public static final DatabaseConnection buildOracleConnection(@NotNull String hostName, @NotNull String databaseName, @NotNull String user, @NotNull String password, @NotNull String port) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        return new DatabaseConnection("jdbc:oracle:thin:@//" + DatabaseConnectionKt.appendPort(hostName, port) + "/" + databaseName, user, password, "oracle.jdbc.OracleDriver", null, 16, null);
    }

    @NotNull
    public static final DatabaseConnection buildConnection(@NotNull EmDatabaseParameters emDatabaseParameters) {
        Intrinsics.checkNotNullParameter((Object)emDatabaseParameters, (String)"emDatabaseParameters");
        return switch (WhenMappings.$EnumSwitchMapping$0[emDatabaseParameters.getType().ordinal()]) {
            case 1 -> DatabaseConnectionKt.buildMssqlConnection(emDatabaseParameters.getHostname(), emDatabaseParameters.getDatabase(), emDatabaseParameters.getUsername(), emDatabaseParameters.getPassword(), emDatabaseParameters.getPort());
            case 2 -> DatabaseConnectionKt.buildPostgresConnection(emDatabaseParameters.getHostname(), emDatabaseParameters.getDatabase(), emDatabaseParameters.getUsername(), emDatabaseParameters.getPassword(), emDatabaseParameters.getPort());
            case 3 -> DatabaseConnectionKt.buildOracleConnection(emDatabaseParameters.getHostname(), emDatabaseParameters.getDatabase(), emDatabaseParameters.getUsername(), emDatabaseParameters.getPassword(), emDatabaseParameters.getPort());
            case 4 -> DatabaseConnectionKt.buildH2Connection();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final DatabaseConnection buildH2Connection() {
        return new DatabaseConnection("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1;", "", "", "org.h2.Driver", null, 16, null);
    }

    @NotNull
    public static final DatabaseConnection buildMssqlConnection(@NotNull String hostName, @NotNull String databaseName, @NotNull String user, @NotNull String password, @NotNull String port) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        return new DatabaseConnection("jdbc:sqlserver://" + DatabaseConnectionKt.appendPort(hostName, port) + ";databaseName=" + databaseName, user, password, "com.microsoft.sqlserver.jdbc.SQLServerDriver", null, 16, null);
    }

    @NotNull
    public static final DatabaseConnection buildPostgresConnection(@NotNull String hostName, @NotNull String databaseName, @NotNull String user, @NotNull String password, @NotNull String port) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        return new DatabaseConnection("jdbc:postgresql://" + DatabaseConnectionKt.appendPort(hostName, port) + "/" + databaseName, user, password, "org.postgresql.Driver", null, 16, null);
    }

    private static final String appendPort(String hostName, String port) {
        return hostName + ":" + port;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.MSSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.PostgreSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.Oracle.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.H2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

