/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.xmlwriter;

import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import com.bmc.ctmconvert.workspace.entities.Folder;
import java.util.Optional;

public class ParentAttributeHandler {
    public void setParent(BaseXmlEntity child, Folder folder) {
        String folderName = folder.getName();
        StringBuilder pathBuilder = new StringBuilder(folderName);
        ParentWalker walker = new ParentWalker(this, parent -> pathBuilder.insert(0, parent.getName() + "/"));
        walker.walk(folder);
        child.addAttribute("PARENT_FOLDER", pathBuilder.toString());
    }

    public class ParentWalker {
        FolderHandler handler;

        public ParentWalker(ParentAttributeHandler this$0, FolderHandler handler) {
            this.handler = handler;
        }

        public void walk(Folder folder) {
            Optional currentParent = folder.getParent();
            while (currentParent.isPresent()) {
                this.handler.handleFolder((Folder)currentParent.get());
                currentParent = ((Folder)currentParent.get()).getParent();
            }
        }
    }

    @FunctionalInterface
    public static interface FolderHandler {
        public void handleFolder(Folder var1);
    }
}

