/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.inject;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dataObject.Data;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.flowupdater.data.JobData;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterJobMeetCriteria;
import java.util.List;
import java.util.Map;

public class JobMeetsVariableCriteria
implements FlowUpdaterJobMeetCriteria {
    private String criteriaValue;
    private String criteriaField;

    public JobMeetsVariableCriteria(String criteriaValue, String criteriaField) {
        this.criteriaField = criteriaField;
        this.criteriaValue = criteriaValue;
    }

    @Override
    public boolean isJobMeetCriteria(DataEntity dataEntity) {
        if (!dataEntity.getDataType().equals("JOB")) {
            return false;
        }
        Data data = dataEntity.getData();
        if (!(data instanceof JobData)) {
            return false;
        }
        JobData jobData = (JobData)data;
        return this.variableMatch(jobData, this.criteriaValue, this.criteriaField);
    }

    private boolean variableMatch(JobData jobData, String criteriaValue, String criteriaField) {
        XmlElement jobElement = jobData.getJobXmlElement();
        List varElemets = jobElement.getAllDecnedElementByName("VARIABLE");
        for (XmlElement varElement : varElemets) {
            Map variableAttributes = varElement.getAttributes();
            String varName = (String)variableAttributes.get("NAME");
            boolean variableNameMatch = varName.contains(criteriaField);
            String varValue = (String)variableAttributes.get("VALUE");
            boolean variableValueMatch = varValue.contains(criteriaValue);
            if (!variableNameMatch || !variableValueMatch) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getReplaceCriteria() {
        return this.criteriaField;
    }

    @Override
    public String getSearchCriteria() {
        return this.criteriaValue;
    }
}

