/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.convertor;

import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataEntityId;
import com.bmc.ctmconvert.flowupdater.data.JobData;
import com.bmc.ctmconvert.flowupdater.inject.CopyCommonAttributesFromJobToJob;
import com.bmc.ctmconvert.flowupdater.inject.CopyCommonElementsFromJobToJob;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterCopyCond;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterCopySchedulingCriteria;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterCopyTaskTypeCriteria;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterOnCopierToJob;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterSingleJobInjector;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterVariableCopier;
import com.bmc.ctmconvert.flowupdater.inject.JobInjector;
import com.bmc.ctmconvert.flowupdater.inject.RuleManagerHolder;
import com.bmc.ctmconvert.flowupdater.inject.XmlAction;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HandleMatchedJobsToJob {
    public JobData injectedJobDataEntry;
    private Workspace workspace;
    private HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap;

    public HandleMatchedJobsToJob(Workspace workspac, JobData injectedJobDataEntry, HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap) {
        this.workspace = workspac;
        this.injectedJobDataEntry = injectedJobDataEntry;
        this.dataEntityToWorkspaceEntityMap = dataEntityToWorkspaceEntityMap;
    }

    public void handle(List<DataEntity> matchedJobs, JobInjector jobInjector, FlowUpdaterSingleJobInjector copyDataToInjected) {
        Map<BaseXmlEntity, BaseXmlEntity> OriginalToJobMap = this.injectJob(matchedJobs, jobInjector);
        List<XmlAction> actions = this.getSingleJobInjectionActions();
        copyDataToInjected.act(OriginalToJobMap, actions);
    }

    private Map<BaseXmlEntity, BaseXmlEntity> injectJob(List<DataEntity> matchedJobs, JobInjector jobInjector) {
        for (DataEntity matchJob : matchedJobs) {
            WorkspaceId jobWsId = this.dataEntityToWorkspaceEntityMap.get(matchJob.getId());
            IWorkspaceEntity jobWsEntity = this.workspace.getEntityByID(jobWsId);
            BaseXmlEntity job = jobInjector.generateJob(this.injectedJobDataEntry, jobWsEntity, (IWorkspace)this.workspace);
            this.dataEntityToWorkspaceEntityMap.put(matchJob.getId(), job.getId());
        }
        Map<BaseXmlEntity, BaseXmlEntity> ret = jobInjector.getOriginalJobToSubFoldersMap();
        return ret;
    }

    private List<XmlAction> getSingleJobInjectionActions() {
        ArrayList<XmlAction> actions = new ArrayList<XmlAction>();
        actions.add(new FlowUpdaterCopySchedulingCriteria());
        actions.add(new CopyCommonAttributesFromJobToJob());
        actions.add(new FlowUpdaterVariableCopier());
        actions.add(new FlowUpdaterOnCopierToJob());
        actions.add(new CopyCommonElementsFromJobToJob());
        actions.add(new FlowUpdaterCopyCond());
        RulesDataSet currentRules = RuleManagerHolder.get().getCurrentRules();
        Boolean isAppendToDescription = currentRules.getBooleanRule("Flow Updater Rules", new String[]{"AppendDataToDescription"});
        if (isAppendToDescription.booleanValue()) {
            actions.add(new FlowUpdaterCopyTaskTypeCriteria());
        }
        return actions;
    }
}

