/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.convertor;

import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.convertor.actions.FoldersCreator;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataEntityId;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterAttrOfXmlElement;
import com.bmc.ctmconvert.flowupdater.convertor.FlowUpdaterloadDeToWs;
import com.bmc.ctmconvert.flowupdater.data.FolderData;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.entities.FolderXmlEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;

public class FlowUpdaterFolderCreator
implements FoldersCreator {
    private Workspace ws;
    DataObject dataObject;
    HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap;

    public FlowUpdaterFolderCreator(DataObject dataObj, Workspace workspace, HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap) {
        this.ws = workspace;
        this.dataObject = dataObj;
        this.dataEntityToWorkspaceEntityMap = dataEntityToWorkspaceEntityMap;
    }

    public void act() {
        this.dataObject.stream().filter(this.isFolder()).forEach(this::generateFolder);
    }

    private Predicate<DataEntity> isFolder() {
        return de -> de.getData().getDataType().equals("FOLDER");
    }

    private void generateFolder(DataEntity de) {
        ArrayList<NewMessage> messages = new ArrayList<NewMessage>();
        String name = this.getFolderName(de, messages);
        WorkspaceId id = new WorkspaceId();
        if (de.getData() instanceof FolderData) {
            FolderData folderData = (FolderData)de.getData();
            FlowUpdaterAttrOfXmlElement attrOfXmlElement = new FlowUpdaterAttrOfXmlElement(folderData.getJobXmlElement());
            FolderXmlEntity wsFolder = new FolderXmlEntity(id, name, attrOfXmlElement.getXmlTagName());
            for (NewMessage message : messages) {
                wsFolder.addMessage(message);
            }
            this.dataEntityToWorkspaceEntityMap.put(de.getId(), id);
            FlowUpdaterloadDeToWs flowUpdaterloadDeToWs = new FlowUpdaterloadDeToWs();
            flowUpdaterloadDeToWs.loadDeToWs(attrOfXmlElement, (BaseXmlEntity)wsFolder);
            this.ws.addFolder((Folder)wsFolder);
        }
    }

    private String getFolderName(DataEntity dataEntity, ArrayList<NewMessage> messages) {
        return dataEntity.getAttributes().findFirst("FOLDER_NAME").orElse("");
    }
}

