/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.break_flow;

import com.bmc.ctmconvert.flowupdater.break_flow.Dependencies;
import com.bmc.ctmconvert.flowupdater.break_flow.DependenciesImp;
import com.bmc.ctmconvert.workspace.DoCond;
import com.bmc.ctmconvert.workspace.IOnStatement;
import com.bmc.ctmconvert.workspace.OrderableEntity;
import com.bmc.ctmconvert.workspace.entities.IDo;
import com.bmc.ctmconvert.workspace.entities.InCondition;
import com.bmc.ctmconvert.workspace.entities.OutCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DependencyFinder {
    List<OrderableEntity> jobs;
    private DependenciesImp dependencies;

    public DependencyFinder(List<OrderableEntity> jobs) {
        this.jobs = jobs;
        this.dependencies = new DependenciesImp();
        this.generateDependencies();
    }

    private void generateDependencies() {
        Map<String, List<OrderableEntity>> inconditionToEntites = this.createInConditionMap();
        Map<String, List<OrderableEntity>> outconditionToEntites = this.createOutConditionMap();
        for (String incondintion : inconditionToEntites.keySet()) {
            if (!outconditionToEntites.containsKey(incondintion)) continue;
            List<OrderableEntity> jobsWithIn = inconditionToEntites.get(incondintion);
            List<OrderableEntity> jobsWithOut = outconditionToEntites.get(incondintion);
            for (OrderableEntity jobWithOut : jobsWithOut) {
                for (OrderableEntity jobWithIn : jobsWithIn) {
                    this.dependencies.add(jobWithOut, jobWithIn);
                }
            }
        }
    }

    public List<OrderableEntity> getEntityDependencies(OrderableEntity entity) {
        return this.dependencies.getEntityDependencies(entity);
    }

    private Map<String, List<OrderableEntity>> createOutConditionMap() {
        HashMap<String, List<OrderableEntity>> outConditionMap = new HashMap<String, List<OrderableEntity>>();
        for (OrderableEntity OrderableEntity2 : this.jobs) {
            List outConditionsList = OrderableEntity2.getOutConditions().stream().filter(outCondition -> outCondition.getSign().equals("+")).collect(Collectors.toList());
            for (OutCondition outCondition2 : outConditionsList) {
                if (outConditionMap.containsKey(outCondition2.getName())) {
                    ((List)outConditionMap.get(outCondition2.getName())).add(OrderableEntity2);
                    continue;
                }
                ArrayList<OrderableEntity> newList = new ArrayList<OrderableEntity>();
                newList.add(OrderableEntity2);
                outConditionMap.put(outCondition2.getName(), newList);
            }
            List onDo = OrderableEntity2.getOnDo();
            for (IOnStatement on : onDo) {
                List dos = on.getDos();
                List<DoCond> doConds = this.getDoCond(dos);
                for (DoCond doCond : doConds) {
                    if (outConditionMap.containsKey(doCond.getName())) {
                        ((List)outConditionMap.get(doCond.getName())).add(OrderableEntity2);
                        continue;
                    }
                    ArrayList<OrderableEntity> newList = new ArrayList<OrderableEntity>();
                    newList.add(OrderableEntity2);
                    outConditionMap.put(doCond.getName(), newList);
                }
            }
        }
        return outConditionMap;
    }

    private List<DoCond> getDoCond(List<IDo> dos) {
        Predicate<IDo> onlyAddSign = dodnt -> {
            Map attributes = dodnt.getAttributes();
            String sign = (String)attributes.get("SIGN");
            boolean isAddCondition = sign != null && sign.equals("+");
            return isAddCondition;
        };
        List<DoCond> doCond = dos.stream().filter(onlyAddSign).filter(doEnt -> doEnt instanceof DoCond).map(doEnt -> (DoCond)doEnt).collect(Collectors.toList());
        return doCond;
    }

    private Map<String, List<OrderableEntity>> createInConditionMap() {
        HashMap<String, List<OrderableEntity>> inConditionMap = new HashMap<String, List<OrderableEntity>>();
        for (OrderableEntity job : this.jobs) {
            List inConditionsList = job.getInConditions();
            for (InCondition inCondition : inConditionsList) {
                if (inConditionMap.containsKey(inCondition.getName())) {
                    ((List)inConditionMap.get(inCondition.getName())).add(job);
                    continue;
                }
                ArrayList<OrderableEntity> newList = new ArrayList<OrderableEntity>();
                newList.add(job);
                inConditionMap.put(inCondition.getName(), newList);
            }
        }
        return inConditionMap;
    }

    public String toString() {
        return "DependencyFinder [dependenciesMap=" + String.valueOf(this.dependencies) + "]";
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }
}

