/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.assessmentreport;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.flowupdater.data.JobData;
import com.bmc.ctmconvert.flowupdater.globs.FlowUpdaterGlobals;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class FlowUpdaterAssesmentReportTreeGenerator {
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode matchedJobs;

    public FlowUpdaterAssesmentReportTreeGenerator(String rootNodeName) {
        this.root = new DefaultMutableTreeNode(rootNodeName);
        this.matchedJobs = new DefaultMutableTreeNode(FlowUpdaterGlobals.MATCHEDJOBS);
        this.root.add(this.matchedJobs);
    }

    public DefaultMutableTreeNode generateNodeTree(Stream<DataEntity> jobsMeetCriteria) {
        if (jobsMeetCriteria != null) {
            List<DataEntity> jobsList = jobsMeetCriteria.collect(Collectors.toList());
            this.buildTreeMap(jobsList);
            String matchedJobsEntryWithCountOfJobs = String.valueOf(FlowUpdaterGlobals.MATCHEDJOBS) + "(" + jobsList.size() + ")";
            this.matchedJobs.setUserObject(matchedJobsEntryWithCountOfJobs);
        }
        return this.root;
    }

    private void buildTreeMap(List<DataEntity> jobsList) {
        if (jobsList != null && !jobsList.isEmpty()) {
            jobsList.forEach(this::addToTreeMap);
        }
    }

    private void addToTreeMap(DataEntity job) {
        boolean isJob = job.getDataType().equals("JOB");
        if (isJob) {
            XmlElement jobXmlElement = this.getJobXmlElement(job);
            String parentFolderString = jobXmlElement.getAttribute("PARENT_FOLDER");
            String jobname = this.extractJobname(job);
            this.buildTree(jobname, parentFolderString, this.matchedJobs);
        }
    }

    private void buildTree(String jobName, String parentFolderString, DefaultMutableTreeNode tempRoot) {
        String currentFolder = "";
        if (parentFolderString.isEmpty()) {
            tempRoot.add(new DefaultMutableTreeNode(jobName));
            return;
        }
        int indexOf = parentFolderString.indexOf("/");
        if (indexOf != -1) {
            currentFolder = parentFolderString.substring(0, indexOf);
            Enumeration<TreeNode> children = tempRoot.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode nextElement = (DefaultMutableTreeNode)children.nextElement();
                String userObject = (String)nextElement.getUserObject();
                if (!userObject.equals(currentFolder)) continue;
                this.buildTree(jobName, parentFolderString.substring(indexOf + 1, parentFolderString.length()), nextElement);
                return;
            }
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(currentFolder);
            tempRoot.add(newChild);
            this.buildTree(jobName, parentFolderString.substring(indexOf + 1, parentFolderString.length()), newChild);
            return;
        }
        Enumeration<TreeNode> children = tempRoot.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode nextElement = (DefaultMutableTreeNode)children.nextElement();
            String userObject = (String)nextElement.getUserObject();
            if (!userObject.equals(parentFolderString)) continue;
            this.buildTree(jobName, "", nextElement);
            return;
        }
        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(parentFolderString);
        tempRoot.add(newChild);
        this.buildTree(jobName, "", newChild);
    }

    private XmlElement getJobXmlElement(DataEntity job) {
        JobData jobData = (JobData)job.getData();
        XmlElement jobXmlElement = jobData.getJobXmlElement();
        return jobXmlElement;
    }

    private String extractJobname(DataEntity job) {
        XmlElement jobXmlElement = this.getJobXmlElement(job);
        String jobname = jobXmlElement.getAttribute("JOBNAME");
        return jobname;
    }
}

