/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.reader;

import com.bmc.ctmconvert.connect_direct.antlr.CDProcessBaseListener;
import com.bmc.ctmconvert.connect_direct.antlr.CDProcessParser;
import com.bmc.ctmconvert.connect_direct.data.CopyStatement;
import com.bmc.ctmconvert.connect_direct.data.ProcessHeader;
import com.bmc.ctmconvert.connect_direct.data.Statement;
import com.bmc.ctmconvert.connect_direct.reader.CDProcessFileListener;
import com.bmc.ctmconvert.dataObject.IAttribute;
import com.bmc.ctmconvert.dataObject.entities.Attribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class ProcessListenerImpl
extends CDProcessBaseListener {
    private CDProcessFileListener listener;
    private Statement statement;

    public ProcessListenerImpl(CDProcessFileListener listener) {
        this.listener = listener;
    }

    @Override
    public void exitProcessHeader(CDProcessParser.ProcessHeaderContext ctx) {
        String pnodeVal;
        String originalText = this.getOriginalText(ctx);
        String string = ctx.args != null ? (ctx.args.pnode != null ? ctx.args.pnode.getText() : null) : (pnodeVal = null);
        String snodeVal = ctx.args != null ? (ctx.args.snode != null ? ctx.args.snode.getText() : null) : null;
        ProcessHeader header = new ProcessHeader(ctx.name.getText(), originalText, pnodeVal, snodeVal);
        if (ctx.args != null && !ctx.args.processArg().isEmpty()) {
            ctx.args.processArg().forEach(v -> header.addVariable(this.stripLeadingAmpersand(v.argname().getText()), v.argval() == null ? "" : this.stripBracketChars(v.argval().getText())));
        }
        this.listener.onProcessHeader(header);
    }

    private String stripLeadingAmpersand(String text) {
        return text.startsWith("&") ? text.substring(1) : text;
    }

    @Override
    public void exitStatement(CDProcessParser.StatementContext ctx) {
        String label;
        String type = ctx.statementBody().getStart().getText().toUpperCase();
        String originalText = this.getOriginalText(ctx);
        String string = label = ctx.label != null ? ctx.label.getText() : null;
        if (type.equals("COPY")) {
            this.statement = new CopyStatement(type, originalText, label);
            CDProcessParser.CopyStatementArgumentsContext copyStatementArguments = ctx.statementBody().copyStatementArguments();
            if (copyStatementArguments.from.dsn != null) {
                this.statement.add((IAttribute)Attribute.from((String)"FROM_DSN", (String)this.stripBracketChars(copyStatementArguments.from.dsname(0))));
            } else if (copyStatementArguments.from.file != null) {
                this.statement.add((IAttribute)Attribute.from((String)"FROM_DSN", (String)this.stripBracketChars(copyStatementArguments.from.dsname(0))));
            }
            if (!copyStatementArguments.from.node().isEmpty()) {
                this.statement.add((IAttribute)Attribute.from((String)"FROM_NODE", (String)copyStatementArguments.from.node(0).getText().toUpperCase()));
            }
            if (copyStatementArguments.to.dsn != null) {
                this.statement.add((IAttribute)Attribute.from((String)"TO_DSN", (String)this.stripBracketChars(copyStatementArguments.to.dsname(0))));
            } else if (copyStatementArguments.to.file != null) {
                this.statement.add((IAttribute)Attribute.from((String)"TO_DSN", (String)this.stripBracketChars(copyStatementArguments.to.dsname(0))));
            }
            if (!copyStatementArguments.to.node().isEmpty()) {
                this.statement.add((IAttribute)Attribute.from((String)"TO_NODE", (String)copyStatementArguments.to.node(0).getText().toUpperCase()));
            }
        } else {
            this.statement = new Statement(type, originalText, label);
        }
        this.listener.onStatement(this.statement);
    }

    private String stripBracketChars(String s) {
        Matcher m = Pattern.compile("^([\"'\\\\])(.*)\\1$").matcher(s);
        if (m.find()) {
            return m.group(2);
        }
        return this.stripTrailingNewLine(s);
    }

    private String stripBracketChars(CDProcessParser.DsnameContext dsn) {
        Object s = "";
        for (int dp = 0; dp < dsn.getChildCount(); ++dp) {
            ParseTree dsnsubpart = dsn.getChild(dp);
            if (dsnsubpart instanceof CDProcessParser.DsnpartContext) {
                s = (String)s + this.stripBracketChars(dsnsubpart.getText());
                continue;
            }
            if (dsnsubpart.getText().equals("||")) continue;
            s = (String)s + dsnsubpart.getText();
        }
        return this.stripBracketChars((String)s);
    }

    private String stripTrailingNewLine(String s) {
        Matcher m = Pattern.compile("^(.*)[\\r\\n]*$").matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return s;
    }

    private String getOriginalText(ParserRuleContext ctx) {
        int startIndex = ctx.getStart().getStartIndex();
        int endIndex = ctx.getStop().getStartIndex();
        Interval interval = new Interval(startIndex, endIndex);
        return ctx.getStart().getInputStream().getText(interval);
    }
}

