/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.convertor.actions;

import com.bmc.ctmconvert.common.message.GeneralMessage;
import com.bmc.ctmconvert.connect_direct.data.ErrorData;
import com.bmc.ctmconvert.connect_direct.data.ErrorDataParseError;
import com.bmc.ctmconvert.convertor.actions.ConversionAction;
import com.bmc.ctmconvert.dataObject.Data;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.workspace.sourceDefinitions.GeneralSourceDefinitions;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ParsingErrorAction
implements ConversionAction {
    private DataObject dataObject;
    private GeneralSourceDefinitions sourceDefinitions;

    public ParsingErrorAction(DataObject dataObject, GeneralSourceDefinitions sourceDefinitions) {
        this.dataObject = dataObject;
        this.sourceDefinitions = sourceDefinitions;
    }

    public void act() {
        this.dataObject.stream().filter(this.parsingErrors()).forEach(this.issueErrorMessage());
    }

    private Consumer<? super DataEntity> issueErrorMessage() {
        return entity -> {
            Data data = entity.getData();
            if (data instanceof ErrorDataParseError) {
                ErrorDataParseError errorData = (ErrorDataParseError)data;
                String processName = errorData.getFileName();
                GeneralMessage message = new GeneralMessage(processName, "ERR18000", new String[]{errorData.getErrorMessage()});
                this.sourceDefinitions.addGeneralMessage(message);
            }
        };
    }

    private Predicate<? super DataEntity> parsingErrors() {
        return entity -> {
            boolean isErrorDataType = entity.getDataType().equals("ERROR");
            boolean isParsingErrorType = entity.getData().getAttributes().findFirst("ERROR_TYPE").equals(Optional.of(ErrorData.ErrorType.PARSE_ERROR.toString()));
            return isErrorDataType && isParsingErrorType;
        };
    }
}

