/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.assessmentReport;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.connect_direct.data.ErrorData;
import com.bmc.ctmconvert.connect_direct.data.ProcessHeader;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.services.VendorDataManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;

public class CDAssessmentReport
extends AbstractAssessmentReport {
    private HashMap<String, String> nodeId2Description;
    private HashMap<String, HashMap<String, Integer>> nodeSubtots;
    private TreeSet<String> sortedNodes;
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private static int totalCopyNumber;
    private static int totalRuntaskNumber;
    private static int totalRunjobNumber;
    private static int totalSubmitNumber;
    private static int totalErrors;
    private static int totalProcessesNumber;
    private int copySubtot = 0;
    private int runtaskSubtot = 0;
    private int runjobSubtot = 0;
    private int submitSubtot = 0;
    private int ifSubtot = 0;
    private int otherSubtot = 0;
    private List<DataEntity> foldersList;
    private final String processNodeName = "Process Files";
    private final String unrecognizedNode = "Unrecognized Files";

    public CDAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.foldersList = new ArrayList<DataEntity>();
        this.nodeId2Description = new HashMap();
        this.nodeSubtots = new HashMap();
        this.sortedNodes = new TreeSet();
        totalCopyNumber = 0;
        totalRuntaskNumber = 0;
        totalRunjobNumber = 0;
        totalSubmitNumber = 0;
        totalErrors = 0;
        totalProcessesNumber = 0;
    }

    private boolean all(DataEntity de) {
        return true;
    }

    private Map<DataEntity, List<DataEntity>> createHierarchy(DataObject DO) {
        HashMap<DataEntity, List<DataEntity>> hirarchyStruct = new HashMap<DataEntity, List<DataEntity>>();
        DO.stream().filter(de -> de.getData() instanceof ProcessHeader || de.getData() instanceof ErrorData).forEach(this::addFoldertoList);
        for (DataEntity de2 : this.foldersList) {
            if (DO.getChildrenOf(de2, this::all).isEmpty()) continue;
            hirarchyStruct.put(de2, DO.getChildrenOf(de2, this::all));
        }
        return hirarchyStruct;
    }

    private void addFoldertoList(DataEntity de) {
        this.foldersList.add(de);
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        DataObject dataObject = VendorDataManager.instance().getDataObject();
        Map<DataEntity, List<DataEntity>> hirarchyStruct = this.createHierarchy(dataObject);
        Set<DataEntity> processes = hirarchyStruct.keySet();
        totalProcessesNumber = processes.size();
        String iFileName = null;
        for (DataEntity process : this.foldersList) {
            StringBuilder builder = new StringBuilder();
            if (process.getData() instanceof ProcessHeader) {
                iFileName = (String)process.getAttributes().findFirst("process_full_path_to_file_in_project").get();
            } else if (process.getData() instanceof ErrorData) {
                iFileName = (String)process.getAttributes().findFirst("PROCESS_FULL_PATH_FILE_NAME").get();
            }
            String line = null;
            try {
                FileReader fileReader = new FileReader(iFileName);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((line = bufferedReader.readLine()) != null) {
                    builder.append(line + "\n");
                }
                bufferedReader.close();
                fileReader.close();
                this.nodeId2Description.put((String)process.getAttributes().findFirst("process_file_name").get(), builder.toString());
                int size = 0;
                if (!dataObject.getChildrenOf(process, this::all).isEmpty() && process.getData() instanceof ProcessHeader) {
                    List listOfProcessStatments = dataObject.getChildrenOf(process, this::all);
                    size = listOfProcessStatments.size();
                    for (DataEntity statement : listOfProcessStatments) {
                        if (((String)statement.getAttributes().findFirst("STATEMENT_TYPE").get()).equals("COPY")) {
                            ++totalCopyNumber;
                            ++this.copySubtot;
                            continue;
                        }
                        if (((String)statement.getAttributes().findFirst("STATEMENT_TYPE").get()).equals("RUN JOB")) {
                            ++totalRunjobNumber;
                            ++this.runjobSubtot;
                            continue;
                        }
                        if (((String)statement.getAttributes().findFirst("STATEMENT_TYPE").get()).equals("RUN TASK")) {
                            ++totalRuntaskNumber;
                            ++this.runtaskSubtot;
                            continue;
                        }
                        if (!((String)statement.getAttributes().findFirst("STATEMENT_TYPE").get()).equals("SUBMIT")) continue;
                        ++totalSubmitNumber;
                        ++this.submitSubtot;
                    }
                }
                if (size == 0) {
                    ++totalErrors;
                }
                this.sortedNodes.add((String)process.getAttributes().findFirst("process_file_name").get() + " (" + Integer.valueOf(this.copySubtot + this.runtaskSubtot + this.runjobSubtot + this.submitSubtot) + ") ");
                this.nodeSubtots.put((String)process.getAttributes().findFirst("process_file_name").get(), new HashMap());
                this.nodeSubtots.get(process.getAttributes().findFirst("process_file_name").get()).put("COPY", this.copySubtot);
                this.nodeSubtots.get(process.getAttributes().findFirst("process_file_name").get()).put("RUN TASK", this.runtaskSubtot);
                this.nodeSubtots.get(process.getAttributes().findFirst("process_file_name").get()).put("RUN JOB", this.runjobSubtot);
                this.nodeSubtots.get(process.getAttributes().findFirst("process_file_name").get()).put("SUBMIT", this.submitSubtot);
                this.nodeSubtots.get(process.getAttributes().findFirst("process_file_name").get()).put("IF", this.ifSubtot);
                this.nodeSubtots.get(process.getAttributes().findFirst("process_file_name").get()).put("other", this.otherSubtot);
                this.copySubtot = 0;
                this.runtaskSubtot = 0;
                this.runjobSubtot = 0;
                this.submitSubtot = 0;
                this.ifSubtot = 0;
                this.otherSubtot = 0;
            }
            catch (FileNotFoundException ex) {
                System.out.println("Unable to open file '" + iFileName + "'");
            }
            catch (IOException ex) {
                System.out.println("Error reading file '" + iFileName + "'");
            }
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode processesRoot = new DefaultMutableTreeNode("Process Files(" + totalProcessesNumber + ")");
        DefaultMutableTreeNode errorRoot = new DefaultMutableTreeNode("Unrecognized Files(" + totalErrors + ")");
        for (String sortProcessNm : this.sortedNodes) {
            String[] nodeParts = sortProcessNm.split("[\\(\\)]");
            if (Integer.valueOf(nodeParts[nodeParts.length - 2]) == 0) {
                errorRoot.add(new DefaultMutableTreeNode(sortProcessNm.replaceAll("\\s*\\(\\s*0\\)\\s*", "")));
                continue;
            }
            processesRoot.add(new DefaultMutableTreeNode(sortProcessNm));
        }
        root.add(processesRoot);
        if (totalErrors != 0) {
            root.add(errorRoot);
        }
        return root;
    }

    protected String getJobInfo(String messageID) {
        return null;
    }

    protected String getJobInfo(DefaultMutableTreeNode node) {
        StringBuilder sb = new StringBuilder();
        if (node != null) {
            if (node.isRoot()) {
                sb.append("Summary:");
                sb.append("\n");
                sb.append("----------------");
                sb.append("\n");
                sb.append(String.format("%-32s\t: %d%s", "Total Number of Process files loaded", totalProcessesNumber, "\n"));
                sb.append(String.format("%-40s\t: %d%s", "Total Number of COPY statements", totalCopyNumber, "\n"));
                sb.append(String.format("%-40s\t: %d%s", "Total Number of RUN statements", totalRunjobNumber + totalRuntaskNumber, "\n"));
                sb.append(String.format("%-40s\t: %d%s", "Total Number of SUBMIT statements", totalSubmitNumber, "\n"));
                sb.append("\n");
                sb.append("\n");
                sb.append("The Conversion Tool converts Connect Direct Process files to Control-M according to the logic below  :  \n\n");
                sb.append(" - Each Process File will be converted to a Control-M SMART folder. \n");
                sb.append(" - Each COPY statement will be converted to File Transfer job. \n");
                sb.append(" - Each RUN statement will be converted to a Dummy job. \n");
                sb.append(" - Each SUBMIT statement will be converted to a Dummy job. \n");
                sb.append(" - Other Connect Direct statement types (GOTO, IF, EIF, EXIT, SYMBOL etc.) are currently not converted,\n relevant Control-M jobs created might require manual update to reflect similar behavior. \n\n");
            } else if (node.isLeaf()) {
                String nodeName = ((String)node.getUserObject()).replaceAll("\\s{1}\\(\\s*[0-9]+\\)\\s*", "");
                sb.append(this.getProcessSummary(nodeName));
                sb.append(this.nodeId2Description.get(nodeName));
            }
        }
        return sb.toString();
    }

    private String getProcessSummary(String processName) {
        StringBuilder processSummary = new StringBuilder();
        processSummary.append("Process " + processName + " consists of the following statements: \n");
        processSummary.append("\n");
        HashMap<String, Integer> processValues = this.nodeSubtots.get(processName);
        processSummary.append(this.getProcessSummaryLine(processValues, "COPY"));
        processSummary.append(this.getProcessSummaryLine(processValues, "RUN JOB"));
        processSummary.append(this.getProcessSummaryLine(processValues, "RUN TASK"));
        processSummary.append(this.getProcessSummaryLine(processValues, "SUBMIT"));
        processSummary.append(this.getProcessSummaryLine(processValues, "IF"));
        processSummary.append(this.getProcessSummaryLine(processValues, "other"));
        processSummary.append("\n");
        processSummary.append("---------------------------------------------------------------------------------------------");
        processSummary.append("\n");
        return processSummary.toString();
    }

    private String getProcessSummaryLine(HashMap<String, Integer> processValues, String key) {
        String toRet = "";
        int value = processValues.get(key);
        if (value != 0) {
            toRet = String.format("%-40s\t: %d%s", key, value, "\n");
        }
        return toRet;
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> nodeGroups = new ArrayList<String>();
        nodeGroups.add(Params.instance().getDatasourceName());
        nodeGroups.add("Process Files");
        return nodeGroups;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        return null;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        return descriptionMap_NodeName_NodeDesc;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        String[] messageIDParts = messageID.split(";");
        return this.nodeId2Description.get(messageIDParts[2].trim());
    }

    protected void updateDescriptionAreaOfParentNode(String nodeName, DefaultMutableTreeNode node) {
    }
}

