/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.jobtypes;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.dummy.DummyUtils;

public class OmtfConverter {
    public static final String BOUNDARY = "_boundary";
    private final AutosysJob job;
    private final String rule;
    public static final String AI_FWTEXT_APPL = "FWTEXT";

    public OmtfConverter(AutosysJob autosysJob, String ruleValue) {
        this.job = autosysJob;
        this.rule = ruleValue;
    }

    public void convert() {
        this.handleDummyRule();
        this.handleAppName();
        this.handleApplTypeAndForm();
        this.handleFileName();
        this.handleTextFilter();
        this.handleExistFlag();
        this.issueMessageForUnsupportedTextMode();
        this.issueMessageForUnsupportedMonitorMode();
        this.issueMessageForUnsupportedLowerBoundary();
        this.issueMessageForUnsupportedUpperBoundary();
    }

    private void issueMessageForUnsupportedUpperBoundary() {
        String boundaryType = "upper";
        this.issueMessageForUnsupportedBoundary(boundaryType + BOUNDARY, boundaryType);
    }

    private void issueMessageForUnsupportedBoundary(String mode, String boundaryString) {
        String boundary = this.job.getSourceAttr(mode);
        if (!boundary.isEmpty()) {
            this.job.addMessage("WRN4072", this.job.getOriginalJobName(), this.job.getJobName(), boundaryString, boundary);
        }
    }

    private void issueMessageForUnsupportedLowerBoundary() {
        String boundaryType = "lower";
        this.issueMessageForUnsupportedBoundary(boundaryType + BOUNDARY, boundaryType);
    }

    private void handleAppName() {
        this.job.addAutoEdits("%%UCM-APP_NAME", AI_FWTEXT_APPL);
    }

    private void issueMessageForUnsupportedTextMode() {
        this.issueMessageIfOperationNotSupported("text_file_mode", "Line", "WRN4068");
    }

    private void issueMessageIfOperationNotSupported(String mode, String allowedMode, String warningMessage) {
        String textMode = this.job.getSourceAttr(mode);
        if (!allowedMode.equalsIgnoreCase(textMode)) {
            this.job.addMessage(warningMessage, this.job.getJobName(), textMode);
        }
    }

    private void issueMessageForUnsupportedMonitorMode() {
        this.issueMessageIfOperationNotSupported("monitor_mode", "Now", "WRN4069");
    }

    private void handleApplTypeAndForm() {
        this.job.addAttribute("APPL_TYPE", AI_FWTEXT_APPL);
        this.job.addAttribute("APPL_FORM", AI_FWTEXT_APPL);
    }

    private void handleDummyRule() {
        if (!"AI_FWTEXT".equals(this.rule)) {
            DummyUtils.convertToDummyJob((SchedEntity)this.job);
        }
    }

    private void handleExistFlag() {
        String textExistsValue = this.job.getSourceAttr("text_file_filter_exists");
        String res = "0".equals(textExistsValue) ? "False" : "True";
        this.job.addAutoEdits("%%UCM-TEXTEXISTINFILE", res);
    }

    private void handleTextFilter() {
        this.job.addAutoEdits("%%UCM-TEXTINFILE", this.job.getSourceAttr("text_file_filter"));
    }

    private void handleFileName() {
        String omtfTextFileName = this.job.getSourceAttr("text_file_name");
        String fileNameWithFixedVariables = this.handleVariables(omtfTextFileName);
        this.job.addAutoEdits("%%UCM-FILENAME", fileNameWithFixedVariables);
    }

    private String handleVariables(String text) {
        return this.job.getHandleBuiltinAutoEdits().handle(text);
    }
}

