/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.jobtypes;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.HandleBuiltinAutoEdits;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.vc.IFieldValidation;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class I5Converter {
    private final AutosysJob autosysJob;
    private final String replacedFormat = "/QSYS\\.LIB/|\\.LIB";
    private final IFieldValidation fieldValidation = FieldValidation.instance();
    private static final UniqueValueGenerator uniqueJobNameGenerator = new UniqueValueGenerator();

    public I5Converter(AutosysJob autosysJob) {
        this.autosysJob = autosysJob;
    }

    public void convert() {
        String i5Action;
        this.addDefaultAttributes();
        this.addCommonAttributes();
        switch (i5Action = this.autosysJob.getSourceAttr("i5_action")) {
            case "COMMAND": {
                this.convertOS400Command();
                break;
            }
            case "RUN_PROGRAM": {
                this.convertOS400Program();
                break;
            }
            case "RUN_PROG_IN_FILE": {
                this.convertOS400ProgramInFile();
            }
        }
    }

    private void addCommonAttributes() {
        String jobName = this.autosysJob.getSourceAttr("i5_job_name").trim();
        if (jobName.isEmpty()) {
            jobName = this.autosysJob.getJobName();
        }
        if (!jobName.isEmpty()) {
            jobName = this.fieldValidation.validateAndReturnFixedValue("OS400JOBNAME", jobName);
            jobName = this.getUniqueOS400JobName(jobName);
            this.autosysJob.setJobName(jobName);
            this.autosysJob.addAttribute("JOBNAME", jobName);
            this.autosysJob.addAutoEdits("%%OS400-JOB_NAME", jobName);
        }
        this.setAutoeditsJobQueJobDesc(this.autosysJob.getSourceAttr("i5_job_queue"), "%%OS400-JOBQ");
        this.setAutoeditsJobQueJobDesc(this.autosysJob.getSourceAttr("i5_job_desc"), "%%OS400-JOBD");
        this.addOs400Autoedites("owner", "%%OS400-JOB_OWNER");
        this.addOs400Autoedites("i5_curr_lib", "%%OS400-CURLIB");
        this.setOSLda();
        this.setOSLibraryList();
        this.setRunPriority();
        this.setOSLibrary();
    }

    protected String getUniqueOS400JobName(String jobName) {
        String newValue = uniqueJobNameGenerator.getUniqueValue("JOBNAME", jobName, 10, "#", true);
        return this.fieldValidation.validateAndReturnFixedValue("JOBNAME", newValue);
    }

    private void setOSLibrary() {
        String lib = this.autosysJob.getSourceAttr("i5_lib");
        lib = !lib.isEmpty() ? lib.replaceAll("/QSYS\\.LIB/|\\.LIB", "") : "*LIBL";
        this.autosysJob.addAttribute("MEMLIB", lib);
        this.autosysJob.addAutoEdits("%%OS400-MEM_LIB", lib);
    }

    private void setOSLibraryList() {
        String jobLibList = this.autosysJob.getSourceAttr("i5_library_list");
        if (!jobLibList.isEmpty()) {
            jobLibList = jobLibList.replaceAll("\"", "");
            this.autosysJob.addAutoEdits("%%OS400-INLLIBL", HandleBuiltinAutoEdits.replaceGlobalVars(this.autosysJob, jobLibList));
        }
    }

    private void setOSLda() {
        String jobLDA = this.autosysJob.getSourceAttr("i5_lda");
        if (!jobLDA.isEmpty()) {
            String jobUpdatedLda = jobLDA.replaceAll("X'|'|\"", "");
            jobLDA = jobLDA.startsWith("X") ? String.format("*HEX(%s)", jobUpdatedLda) : jobUpdatedLda;
            this.autosysJob.addAutoEdits("%%OS400-LDA", jobLDA);
        }
    }

    private void setAutoeditsJobQueJobDesc(String jobAttr, String os400Autoedits) {
        if (!jobAttr.isEmpty()) {
            jobAttr = jobAttr.replaceAll("/QSYS\\.LIB/|\\.LIB|\"|\\.JOBQ|\\.JOBD", "");
            this.autosysJob.addAutoEdits(os400Autoedits, jobAttr);
        }
    }

    private void setRunPriority() {
        String i5ProcessPriority;
        switch (i5ProcessPriority = this.autosysJob.getSourceAttr("i5_process_priority")) {
            case "HIGH": {
                this.autosysJob.addAutoEdits("%%OS400-RUNPTY", "20");
                break;
            }
            case "ABOVE_NORMAL": {
                this.autosysJob.addAutoEdits("%%OS400-RUNPTY", "35");
                break;
            }
            case "BELOW_NORMAL": {
                this.autosysJob.addAutoEdits("%%OS400-RUNPTY", "70");
                break;
            }
            case "IDLE": {
                this.autosysJob.addAutoEdits("%%OS400-RUNPTY", "99");
            }
        }
    }

    private void convertOs400Params() {
        String paramsVal = this.autosysJob.getSourceAttr("i5_params");
        if (!paramsVal.isEmpty()) {
            AtomicInteger paramIndex = new AtomicInteger(1);
            Map<String, String> params = Stream.of(paramsVal.split(",")).collect(Collectors.toMap(s -> String.format("%%%%OS400-PARM%d", paramIndex.getAndIncrement()), this::convertParametersValue));
            this.autosysJob.addAllAutoEdits(params);
        }
    }

    private String convertParametersValue(String parameterValue) {
        return parameterValue.replaceAll("'|\"", "");
    }

    private void addOs400Autoedites(String autosysSourceAttr, String ctmAttr) {
        String attrValue = this.autosysJob.getSourceAttr(autosysSourceAttr);
        if (!attrValue.isEmpty()) {
            this.autosysJob.addAutoEdits(ctmAttr, attrValue);
        }
    }

    private void addDefaultAttributes() {
        this.autosysJob.addAttribute("TASKTYPE", "Job");
        this.autosysJob.addAttribute("APPL_TYPE", "OS400");
        this.autosysJob.addAttribute("APPL_FORM", "OS/400 Full");
        this.autosysJob.addAttribute("APPL_VER", "*ALL");
        this.autosysJob.addAttribute("CM_VER", "610");
        this.autosysJob.addAutoEdits("%%OS400-AEV_LEN", "4000");
    }

    private void convertOS400ProgramInFile() {
        this.autosysJob.addAutoEdits("%%OS400-OBJTYP", "*FILE");
        String progLibName = this.autosysJob.getSourceAttr("i5_name");
        progLibName = progLibName.replaceAll("/QSYS\\.LIB/|\\.LIB|\\.FILE|\\.MBR", "");
        String[] progLib = progLibName.split("/");
        Object memName = switch (progLib.length) {
            case 1 -> this.getUpdatedMemNameProgInFile(progLib[0]);
            case 2 -> this.getUpdatedMemNameProgInFile(progLib[1]);
            case 3 -> progLib[1] + "/" + progLib[2];
            default -> "";
        };
        this.autosysJob.addAttribute("MEMNAME", (String)memName);
        this.autosysJob.addAutoEdits("%%OS400-MEM_NAME", (String)memName);
        this.setLibraryProgramInFile(progLib);
        this.convertOs400Params();
    }

    private void setLibraryProgramInFile(String[] progLib) {
        if (progLib.length > 1) {
            this.autosysJob.addAutoEdits("%%OS400-MEM_LIB", progLib[0]);
            this.autosysJob.addAttribute("MEMLIB", progLib[0]);
        }
    }

    private String getUpdatedMemNameProgInFile(String memName) {
        return memName.replaceAll("\\(", "/").replaceAll("\\)", "");
    }

    private void convertOS400Program() {
        this.autosysJob.addAutoEdits("%%OS400-OBJTYP", "*PGM");
        String progLibName = this.autosysJob.getSourceAttr("i5_name");
        progLibName = progLibName.replaceAll("/QSYS\\.LIB/|\\.LIB|CALL|\\(|\\)|\\.PGM", "").trim();
        String[] progLib = progLibName.split("/");
        if (progLib.length == 2) {
            this.autosysJob.addAttribute("MEMLIB", progLib[0]);
            this.autosysJob.addAttribute("MEMNAME", progLib[1]);
            this.autosysJob.addAutoEdits("%%OS400-MEM_LIB", progLib[0]);
            this.autosysJob.addAutoEdits("%%OS400-MEM_NAME", progLib[1]);
        } else if (progLib.length == 1) {
            this.autosysJob.addAttribute("MEMNAME", progLib[0]);
            this.autosysJob.addAutoEdits("%%OS400-MEM_NAME", progLib[0]);
        }
        this.convertOs400Params();
    }

    private void convertOS400Command() {
        this.autosysJob.addAutoEdits("%%OS400-OBJTYP", "*CMDLINE");
        String command = this.autosysJob.getSourceAttr("i5_name");
        command = command.replaceAll("/QSYS\\.LIB/|\\.LIB|\\.CMD", "");
        this.autosysJob.addAutoEdits(String.format("%%%%OS400-CMDLINE%s", 1), command);
    }
}

