/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.handlers;

import com.bmc.ctmconvert.autosys.AutosysGlobals;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Map;

public class StartMinsHandler {
    private final IAttrHolder sourceAttributes;
    private final Map<String, String> jobAttributes;
    private String[] startMinsArr;

    public StartMinsHandler(IAttrHolder sourceAttributes, Map<String, String> jobAttributes) {
        this.sourceAttributes = sourceAttributes;
        this.jobAttributes = jobAttributes;
    }

    public void startMinutesToAttribute() {
        int i;
        this.jobAttributes.put("CYCLIC", "1");
        String startMins = this.sourceAttributes.getAttr("start_mins").replaceAll("[\" \t]+", "").trim();
        this.startMinsArr = startMins.split(",+");
        for (int i2 = 0; i2 < this.startMinsArr.length; ++i2) {
            this.startMinsArr[i2] = this.startMinsArr[i2].matches("^\\d$") ? "0" + this.startMinsArr[i2] : this.startMinsArr[i2];
        }
        int interval = 0;
        int intervalCandidate = 0;
        if (this.startMinsArr.length == 1) {
            this.jobAttributes.put("CYCLIC_TYPE", "Interval");
            this.jobAttributes.put("INTERVAL", "60");
            this.setTimeFromWithInterval();
            return;
        }
        int[] startMinsIntArr = new int[this.startMinsArr.length];
        for (i = 0; i < this.startMinsArr.length; ++i) {
            startMinsIntArr[i] = Integer.parseInt(this.startMinsArr[i]);
        }
        Arrays.sort(startMinsIntArr);
        for (i = 1; i < startMinsIntArr.length; ++i) {
            int testVal;
            if (i == 1) {
                intervalCandidate = startMinsIntArr[1] - startMinsIntArr[0];
            }
            if ((testVal = i != startMinsIntArr.length - 1 ? startMinsIntArr[i] - startMinsIntArr[i - 1] : 60 - startMinsIntArr[i] + startMinsIntArr[0]) != intervalCandidate) {
                interval = 0;
                break;
            }
            interval = intervalCandidate;
        }
        if (interval != 0) {
            this.jobAttributes.put("CYCLIC_TYPE", "Interval");
            this.jobAttributes.put("INTERVAL", Integer.toString(interval));
            this.setTimeFromWithInterval();
            return;
        }
        int startHour = 0;
        int startMinute = 0;
        int endHour = 23;
        int endMinute = 59;
        StringBuilder specTimes = new StringBuilder();
        String window = this.sourceAttributes.getAttr("run_window");
        if (window.matches(AutosysGlobals.timeWindowpattern.toString())) {
            String timeFrom = this.jobAttributes.get("TIMEFROM");
            startHour = Integer.parseInt(timeFrom.substring(0, 2));
            startMinute = Integer.parseInt(timeFrom.substring(2, 4));
            String timeTo = this.jobAttributes.get("TIMETO");
            endHour = Integer.parseInt(timeTo.substring(0, 2));
            endMinute = Integer.parseInt(timeTo.substring(2, 4));
        }
        GregorianCalendar start = new GregorianCalendar();
        start.set(11, startHour);
        start.set(12, startMinute);
        start.set(2, 1);
        start.set(5, 1);
        start.set(14, 0);
        start.set(13, 0);
        start.get(0);
        GregorianCalendar end = new GregorianCalendar();
        end.set(11, endHour);
        end.set(12, endMinute);
        end.set(2, 1);
        end.set(5, 1);
        end.set(14, 0);
        end.set(13, 0);
        end.get(0);
        if (endHour < startHour || endHour == startHour && endMinute < startMinute) {
            end.add(5, 1);
        }
        GregorianCalendar current = (GregorianCalendar)start.clone();
        while (current.compareTo(end) < 0) {
            for (String startMinutes : this.startMinsArr) {
                int currMinute = Integer.parseInt(startMinutes);
                current.set(12, currMinute);
                if (current.compareTo(start) < 0 || current.compareTo(end) > 0) continue;
                String nextTime = String.format("%02d%02d", current.get(11), currMinute);
                specTimes.append(specTimes.length() == 0 ? "" : ",");
                specTimes.append(nextTime);
            }
            current.set(12, 0);
            current.add(11, 1);
        }
        this.jobAttributes.put("CYCLIC_TYPE", "SpecificTimes");
        this.jobAttributes.put("CYCLIC_TIMES_SEQUENCE", specTimes.toString());
    }

    private void setTimeFromWithInterval() {
        if (this.jobAttributes.containsKey("TIMEFROM") && !this.jobAttributes.get("TIMEFROM").isEmpty()) {
            Object hrs = this.jobAttributes.get("TIMEFROM").substring(0, 2);
            String mins = this.jobAttributes.get("TIMEFROM").substring(2, 4);
            String minsResult = this.startMinsArr[0];
            int i = 1;
            while (i < this.startMinsArr.length & Integer.parseInt(this.startMinsArr[i - 1]) < Integer.parseInt(mins)) {
                minsResult = this.startMinsArr[i];
                ++i;
            }
            if (Integer.parseInt(this.startMinsArr[this.startMinsArr.length - 1]) >= Integer.parseInt(mins)) {
                this.jobAttributes.put("TIMEFROM", this.jobAttributes.get("TIMEFROM").substring(0, 2) + minsResult);
            } else {
                i = Integer.parseInt((String)hrs);
                hrs = ((i = (i + 1) % 24) < 10 ? "0" : "") + i;
                this.jobAttributes.put("TIMEFROM", (String)hrs + this.startMinsArr[0]);
            }
        } else {
            this.jobAttributes.put("TIMEFROM", "00" + this.startMinsArr[0]);
        }
    }
}

