/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.handlers;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;

public class NRetriesHandler {
    private static final String OneMinuteRetryInterval = "00001M";
    private final IAttrHolder m_sourceAttr;
    private final SchedEntity.TYPE m_type;
    private final String m_jobName;
    private final Map<String, String> m_jobAttr;
    private final List<Properties> onStmtList;
    private final AutosysJob autosysJob;

    public NRetriesHandler(AutosysJob autosysJob) {
        this.m_sourceAttr = autosysJob.getSourceAttr();
        this.m_type = autosysJob.getType();
        this.m_jobName = autosysJob.getJobName();
        this.m_jobAttr = autosysJob.getJobAttr();
        this.onStmtList = autosysJob.getOnStmt(true);
        this.autosysJob = autosysJob;
    }

    public void HandlerNRetries() {
        Predicate<String> isNumberGreaterThen1 = s -> GlobalFunctions.isNumber((String)s) && Integer.parseInt(s) > 1;
        String nRetry = this.m_sourceAttr.getAttr("n_retrys").trim();
        if (!nRetry.equals("NULL") && !nRetry.isEmpty()) {
            boolean retryValueIsNotANumber;
            if (this.m_type != SchedEntity.TYPE.JOB) {
                this.autosysJob.addMessage("WRN4006", this.m_jobName, "n_retrys");
                return;
            }
            boolean bl = retryValueIsNotANumber = !nRetry.matches("^[0-9]+$");
            if (retryValueIsNotANumber) {
                this.autosysJob.addMessage("WRN4005", this.m_jobName, "n_retrys");
            } else if (isNumberGreaterThen1.test(nRetry)) {
                this.m_jobAttr.put("MAXRERUN", nRetry);
                this.m_jobAttr.put("INTERVAL", OneMinuteRetryInterval);
                this.nRetriesStatement();
            }
        }
    }

    private void nRetriesStatement() {
        Properties tmpStatement = new Properties();
        tmpStatement.setProperty("CODE", "NOTOK");
        tmpStatement.setProperty("STMT", "*");
        tmpStatement.setProperty("ACTION", "RERUN");
        this.onStmtList.add(tmpStatement);
    }
}

