/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.handlers;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import java.util.List;
import java.util.Properties;

public class MaxExitSuccHandler {
    private IAttrHolder m_sourceAttr;
    private SchedEntity.TYPE m_type;
    private String m_jobName;
    private List<Properties> onStmtList;
    private AutosysJob autosysJob;

    public MaxExitSuccHandler(AutosysJob autosysJob) {
        this.autosysJob = autosysJob;
        this.m_sourceAttr = autosysJob.getSourceAttr();
        this.m_type = autosysJob.getType();
        this.m_jobName = autosysJob.getJobName();
        this.onStmtList = autosysJob.getOnStmt(true);
    }

    public void handleMaxExitSucc() {
        String maxExit = this.m_sourceAttr.getAttr("max_exit_success").trim();
        if (!maxExit.equals("NULL") && !maxExit.isEmpty()) {
            if (this.m_type != SchedEntity.TYPE.JOB) {
                this.autosysJob.addMessage("WRN4006", this.m_jobName, "max_exit_success");
                return;
            }
            if (!maxExit.matches("^[0-9]+$")) {
                this.autosysJob.addMessage("WRN4005", this.m_jobName, "max_exit_success");
                return;
            }
            this.handleMaxExitSuccStatement(maxExit);
        }
    }

    private void handleMaxExitSuccStatement(String maxExit) {
        Properties tmpStatement = new Properties();
        int intExitCode = Integer.valueOf(maxExit);
        tmpStatement.setProperty("CODE", String.format("COMPSTAT LT %d", ++intExitCode));
        tmpStatement.setProperty("STMT", "*");
        tmpStatement.setProperty("ACTION", "OK");
        this.onStmtList.add(tmpStatement);
    }
}

