/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.handlers;

import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.AutosysSchedulingSettingsConvertor;
import com.bmc.ctmconvert.autosys.AutosysSchedulingUtils;
import com.bmc.ctmconvert.autosys.CyclicDecider;
import com.bmc.ctmconvert.autosys.CyclicHandler;
import com.bmc.ctmconvert.autosys.Dependency;
import com.bmc.ctmconvert.common.EmptyAttrHolder;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AutosysStandaloneJobPredecessorSchedulingHandler {
    private final AutosysDefs autosysDefs;
    private final RulesDataSet rules;
    private final AutosysSchedulingSettingsConvertor schedulingSettingsConvertor;
    private List<Properties> predecessorCalendars;
    private final Map<IAttrHolder, List<IAttrHolder>> predecessorsMap;
    private static final Predicate<Properties> IS_AND = cond -> cond.get("AND_OR").equals("A") || cond.get("AND_OR").equals("AND");
    static final Map<String, String> tokenToJobName = new HashMap<String, String>();

    public AutosysStandaloneJobPredecessorSchedulingHandler(AutosysDefs autosysDefs, RulesDataSet rules, Map<IAttrHolder, List<IAttrHolder>> predecessorsMap) {
        this.autosysDefs = autosysDefs;
        this.rules = rules;
        this.predecessorCalendars = Collections.emptyList();
        this.schedulingSettingsConvertor = autosysDefs.autosysSchedulingConvertor;
        this.predecessorsMap = predecessorsMap;
    }

    public AutosysStandaloneJobPredecessorSchedulingHandler(AutosysDefs autosysDefs, RulesDataSet rules) {
        this(autosysDefs, rules, new HashMap<IAttrHolder, List<IAttrHolder>>());
    }

    public void inheritPredecessorScheduling(AutosysJob autosysJob) {
        if (this.shouldNotInheritScheduling(autosysJob)) {
            return;
        }
        String[] tokens = this.getConditionTokens(autosysJob.getSourceAttr("condition"));
        String[] filteredTokens = (String[])Arrays.stream(tokens).filter(t -> !t.matches("(not|n)\\(.*")).toArray(String[]::new);
        List<IAttrHolder> predecessorAttributes = this.getTheJobAttributes(filteredTokens);
        this.inheritScheduling(autosysJob, filteredTokens, predecessorAttributes);
    }

    private void inheritScheduling(AutosysJob autosysJob, String[] tokens, List<IAttrHolder> predecessorAttributes) {
        String lastConditionName = null;
        if (tokens.length > 0) {
            Dependency dependency = new Dependency(tokens[tokens.length - 1]);
            dependency.setInJob(autosysJob.getJobName());
            lastConditionName = dependency.getDepName(this.rules);
            if (lastConditionName == null) {
                lastConditionName = dependency.getOutJob();
            }
        }
        List<Properties> inConditions = autosysJob.getInConds().stream().filter(p -> !"Y".equals(p.getProperty("notRunningWith"))).toList();
        this.predecessorCalendars = this.getTagsFromPredecessor(inConditions, autosysJob::addMessageWithOriginalJobName, lastConditionName, predecessorAttributes);
        this.inheritCyclicScheduling(autosysJob, predecessorAttributes, new ArrayList<String>());
    }

    private void inheritCyclicScheduling(AutosysJob autosysJob, List<IAttrHolder> predecessorAttributes, List<String> namesOfPredecessors) {
        if (predecessorAttributes.size() > 1) {
            autosysJob.addMessageWithOriginalJobName("WRN4073", new String[0]);
        } else if (predecessorAttributes.size() == 1) {
            this.handleInheritingSinglePredecessorCyclic(autosysJob, predecessorAttributes.getFirst(), namesOfPredecessors);
        }
    }

    private String[] getConditionTokens(String conditions) {
        if (!conditions.equals("NULL") && !conditions.isEmpty()) {
            return conditions.split("\\s+(and|AND|OR|or|&&|&|\\|)\\s+");
        }
        return new String[0];
    }

    private void handleInheritingSinglePredecessorCyclic(AutosysJob autosysJob, IAttrHolder predecessorAttributes, List<String> namesOfPredecessors) {
        if (this.isNoDateConditions(predecessorAttributes.getAttr("date_conditions")) && !namesOfPredecessors.contains(predecessorAttributes.getAttr("insert_job"))) {
            namesOfPredecessors.add(predecessorAttributes.getAttr("insert_job"));
            String[] tokens = this.getConditionTokens(predecessorAttributes.getAttr("condition"));
            List<IAttrHolder> predecessorAttributes1 = this.getTheJobAttributes(tokens);
            this.inheritCyclicScheduling(autosysJob, predecessorAttributes1, namesOfPredecessors);
        } else {
            String version = Params.instance().getGUIVersion();
            CyclicDecider cyclicDecider = new CyclicDecider(predecessorAttributes, this.rules, autosysJob.type(), version, autosysJob.getMessages(), autosysJob.getOriginalJobName());
            CyclicHandler cyclic = new CyclicHandler(cyclicDecider, autosysJob.getJobAttr(), autosysJob.getMessages(), autosysJob.getJobName());
            if (cyclicDecider.couldEntityBeConvertedAsCyclic()) {
                if (AutosysDefs.isCleanUpChecked(this.rules)) {
                    autosysJob.convertTimeWindow(predecessorAttributes.getAttr("run_window"));
                    cyclic.convertCyclic(predecessorAttributes);
                } else {
                    autosysJob.addMessage("WRN4074", autosysJob.getOriginalJobName(), autosysJob.getJobName(), predecessorAttributes.getAttr("insert_job"));
                }
            }
        }
    }

    public List<Properties> getPredecessorsSchedulingCalendars() {
        return this.predecessorCalendars;
    }

    public boolean isNoDateConditions(String sourceAttr) {
        return sourceAttr.equals("NULL") || !sourceAttr.equals("1") && !sourceAttr.equalsIgnoreCase("Y") && !sourceAttr.equalsIgnoreCase("YES");
    }

    private List<Properties> getTagsFromPredecessor(List<Properties> inConds, MessageHandler messageHandler, String lastConditionName, List<IAttrHolder> jobAttributesWithConditions) {
        ArrayList<Properties> tags = new ArrayList<Properties>();
        jobAttributesWithConditions = this.getAllPredecessorsAttrsThatContainsDateConditionWithValueOne(jobAttributesWithConditions, new ArrayList<String>());
        if (!inConds.isEmpty()) {
            CommonOperator opr = this.getCommonOperatorBetweenConds(inConds, lastConditionName);
            if (!jobAttributesWithConditions.isEmpty()) {
                switch (opr.ordinal()) {
                    case 1: {
                        tags.addAll(this.getSchedulingFromPredecessors(jobAttributesWithConditions, cal -> true));
                        break;
                    }
                    case 0: {
                        tags.addAll(this.getSchedulingFromPredecessorCondAnd(jobAttributesWithConditions, messageHandler));
                        break;
                    }
                    case 2: {
                        messageHandler.handleMessage("WRN4070", new String[0]);
                    }
                }
            }
        }
        return tags.stream().filter(calendar -> !this.useParentScheduling((Properties)calendar)).distinct().collect(Collectors.toList());
    }

    private boolean useParentScheduling(Properties calendar) {
        return "*".equals(calendar.getProperty("NAME"));
    }

    private List<IAttrHolder> getAllPredecessorsAttrsThatContainsDateConditionWithValueOne(List<IAttrHolder> jobAttributesWithConditions, List<String> namesOfPredecessors) {
        return jobAttributesWithConditions.stream().flatMap(attr -> {
            ArrayList<IAttrHolder> result = new ArrayList<IAttrHolder>();
            if (!this.isNoDateConditions(attr.getAttr("date_conditions"))) {
                result.add((IAttrHolder)attr);
            }
            if (!namesOfPredecessors.contains(attr.getAttr("insert_job"))) {
                List<IAttrHolder> fromPredecessor;
                String predName = attr.getAttr("insert_job");
                namesOfPredecessors.add(predName);
                String[] tokens = this.getConditionTokens(attr.getAttr("condition"));
                List<IAttrHolder> predecessorAttributes = this.getTheJobAttributes(tokens);
                if (predecessorAttributes.isEmpty()) {
                    predecessorAttributes = this.getParentBoxAttributes((IAttrHolder)attr);
                }
                if ((fromPredecessor = this.predecessorsMap.get(attr)) == null) {
                    fromPredecessor = this.getAllPredecessorsAttrsThatContainsDateConditionWithValueOne(predecessorAttributes, namesOfPredecessors);
                    this.predecessorsMap.put((IAttrHolder)attr, fromPredecessor);
                }
                result.addAll(fromPredecessor);
            }
            return result.stream();
        }).collect(Collectors.toList());
    }

    @NotNull
    private List<IAttrHolder> getParentBoxAttributes(IAttrHolder attr) {
        IAttrHolder boxAtr = this.autosysDefs.getJobAttrByJobName(attr.getAttr("box_name"));
        if (boxAtr != null) {
            return List.of(boxAtr);
        }
        return List.of();
    }

    private List<Properties> getSchedulingFromPredecessorCondAnd(List<IAttrHolder> jobsAttributes, MessageHandler messageHandler) {
        if (this.issueWarningMessageForCalendars(jobsAttributes)) {
            messageHandler.handleMessage("WRN4071", new String[0]);
        }
        List<Properties> inheritedCalendars = this.getSchedulingFromPredecessors(jobsAttributes, cal -> cal.get("WEEKDAYS") == null);
        List<String> weekdays = this.getDaysOfWeekFromJobs(jobsAttributes);
        if (!weekdays.isEmpty()) {
            inheritedCalendars.add(this.createIntersectionWeekDaysCalendar(weekdays));
        }
        return inheritedCalendars;
    }

    private List<String> getDaysOfWeekFromJobs(List<IAttrHolder> jobAttributes) {
        ArrayList<String> weekdays = new ArrayList<String>();
        jobAttributes.forEach(jobAttr -> {
            if (!this.getAttr((IAttrHolder)jobAttr, "days_of_week").isEmpty()) {
                weekdays.add(jobAttr.getAttr("days_of_week"));
            }
        });
        return weekdays;
    }

    private boolean issueWarningMessageForCalendars(List<IAttrHolder> jobAttributes) {
        return jobAttributes.stream().anyMatch(jobAttr -> !this.getAttr((IAttrHolder)jobAttr, "run_calendar").isEmpty() || !this.getAttr((IAttrHolder)jobAttr, "exclude_calendar").isEmpty());
    }

    private String getIntersectionWeekDaysStr(List<String> weekdays) {
        String weekStr = weekdays.getFirst();
        for (int i = 1; i < weekdays.size(); ++i) {
            weekStr = this.createCommonDaysOfWeek(weekStr, weekdays.get(i));
        }
        return weekStr;
    }

    private Properties createIntersectionWeekDaysCalendar(List<String> weekdays) {
        IAttrHolder attrHolder = this.generateEmptyAttributesWithDaysOfWeek(this.getIntersectionWeekDaysStr(weekdays));
        String tagId = this.schedulingSettingsConvertor.generateTagsId(attrHolder);
        return this.schedulingSettingsConvertor.getWeekDaysProperties(new AutosysSchedulingUtils(attrHolder), tagId);
    }

    private String getAttr(IAttrHolder attrHolder, String field) {
        String value = attrHolder.getAttr(field);
        if (value == null || value.equals("NULL")) {
            value = "";
        }
        return value;
    }

    private List<Properties> getSchedulingFromPredecessors(List<IAttrHolder> nonStandAloneJobsAttributesWithCondition, Predicate<Properties> filter) {
        return nonStandAloneJobsAttributesWithCondition.stream().flatMap(attr -> this.schedulingSettingsConvertor.createSchedulingSettingsForEntity((IAttrHolder)attr).stream()).filter(filter).collect(Collectors.toList());
    }

    private CommonOperator getCommonOperatorBetweenConds(List<Properties> inConds, String lastConditionName) {
        long numberOfAnds = 0L;
        CommonOperator retVal = CommonOperator.MIX;
        if (inConds.size() > 1) {
            numberOfAnds = this.getCountOfAndOperator(inConds, lastConditionName);
        }
        if (numberOfAnds == 0L) {
            retVal = CommonOperator.OR;
        } else if (numberOfAnds == (long)(inConds.size() - 1)) {
            retVal = CommonOperator.AND;
        }
        return retVal;
    }

    private long getCountOfAndOperator(List<Properties> inConds, String lastConditionName) {
        long count = inConds.stream().filter(IS_AND).count();
        if (inConds.stream().filter(IS_AND).map(cond -> cond.get("NAME")).anyMatch(lastConditionName::equals)) {
            --count;
        }
        return count;
    }

    private List<IAttrHolder> getTheJobAttributes(String[] tokens) {
        ArrayList<IAttrHolder> nonStandAloneJobsCondNames = new ArrayList<IAttrHolder>();
        for (String token : tokens) {
            String outJob = this.getOutJobName(token);
            IAttrHolder outJobAttr = this.autosysDefs.getJobAttrByJobName(outJob);
            if (outJobAttr == null) continue;
            nonStandAloneJobsCondNames.add(outJobAttr);
        }
        return nonStandAloneJobsCondNames;
    }

    private String getOutJobName(String token) {
        return tokenToJobName.computeIfAbsent(token, t -> new Dependency((String)t).getOutJob());
    }

    private String createCommonDaysOfWeek(String daysOfWeekJob1, String daysOfWeekJob2) {
        HashSet<String> intersectionSet = new HashSet<String>(List.of(daysOfWeekJob1.split(",")));
        intersectionSet.retainAll(List.of(daysOfWeekJob2.split(",")));
        return String.join((CharSequence)",", intersectionSet);
    }

    private IAttrHolder generateEmptyAttributesWithDaysOfWeek(String weekStr) {
        return new EmptyAttrHolder().defaultToNull().withAttr("alarm_if_fail", "1").withAttr("date_conditions", "1").withAttr("days_of_week", weekStr);
    }

    private boolean shouldNotInheritScheduling(AutosysJob autosysJob) {
        return !this.isNoDateConditions(autosysJob.getSourceAttr("date_conditions"));
    }

    private static enum CommonOperator {
        AND,
        OR,
        MIX;

    }
}

