/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JilTable
extends CsvFile {
    private AutosysDefs m_father;
    private List<String> jobNames = new ArrayList<String>();

    public JilTable() {
    }

    public JilTable(AutosysDefs father) {
        this();
        this.m_father = father;
    }

    protected void handleRecord(IAttrHolder job, int record_number) {
        if (job.getAttr(this.m_father.getEntNameFieldName()).isEmpty()) {
            return;
        }
        Map<String, AttrHolderList> jobHierarchy = this.m_father.getParents();
        String parentBoxName = job.getAttr(this.m_father.getParentEntFieldName());
        String jobName = job.getAttr(this.m_father.getEntNameFieldName());
        this.jobNames.add(jobName);
        AttrHolderList childJobs = jobHierarchy.get(parentBoxName);
        if (childJobs == null) {
            childJobs = new AttrHolderList();
            jobHierarchy.put(parentBoxName, childJobs);
        }
        childJobs.add((Object)job);
    }

    public void saveCsv(Map<String, AttrHolderList> boxes, OutputStream csvFile) {
        boolean headerWriten = false;
        try {
            BufferedWriter fileBW = new BufferedWriter(new OutputStreamWriter(csvFile));
            for (String key : boxes.keySet()) {
                if (!headerWriten) {
                    IAttrHolder tmpAH = (IAttrHolder)boxes.get(key).get(0);
                    fileBW.write(tmpAH.getCsvHeader());
                    fileBW.write("\n");
                    headerWriten = true;
                }
                AttrHolderList list = boxes.get(key);
                for (IAttrHolder job : list) {
                    String csvRow = job.toString();
                    fileBW.write(csvRow);
                    fileBW.write("\n");
                }
            }
            fileBW.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public boolean isExplicitlyDefined(String jobName) {
        return this.jobNames.contains(jobName);
    }

    public HashMap<String, Integer> getHeaders() {
        return this.m_header2Index;
    }
}

