/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GlobalVariables {
    private static final Pattern GLOBAL_VARIABLE_PATTERN = Pattern.compile("(?<name>.{64})\\s(?<value>.{100}).*");
    private final List<GlobalVariable> variables;

    public GlobalVariables(InputStream input) {
        this.variables = this.load(input);
    }

    private List<GlobalVariable> load(InputStream input) {
        if (input != null) {
            return new BufferedReader(new InputStreamReader(input)).lines().filter(line -> !line.startsWith("___") && !line.isEmpty() && !line.startsWith("Global Name")).map(this::toGlobalVariable).filter(GlobalVariable::isNotEmpty).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private GlobalVariable toGlobalVariable(String line) {
        Matcher matcher = GLOBAL_VARIABLE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return new GlobalVariable(matcher.group("name").trim(), matcher.group("value").trim());
        }
        return GlobalVariable.EMPTY;
    }

    public List<GlobalVariable> getVariables() {
        return this.variables;
    }

    public List<Map<String, String>> toActions() {
        return this.variables.stream().map(variable -> Map.of("ACTENTTYPE", "GLOBALVAR", "JOBID", "Global", "ACTENTNAME", variable.getName(), "ACTDESC", variable.getValue(), "ACTENTQTY", variable.getValue(), "ACTSTATUS", "0")).collect(Collectors.toList());
    }

    public static class GlobalVariable {
        public static final GlobalVariable EMPTY = new GlobalVariable("", "");
        private final String name;
        private final String value;

        public static boolean isNotEmpty(GlobalVariable globalVariable) {
            return globalVariable != EMPTY;
        }

        public GlobalVariable(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GlobalVariable that = (GlobalVariable)o;
            return this.getName().equals(that.getName()) && this.getValue().equals(that.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getValue());
        }

        public String toString() {
            return "GlobalVariable{name='" + this.name + "', value='" + this.value + "'}";
        }
    }
}

