/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.FileTransferConvertor;
import com.bmc.ctmconvert.common.GlobalFunctions;
import java.util.Optional;

public class AutosysSCPConvertor
extends FileTransferConvertor {
    public AutosysSCPConvertor(AutosysJob autosysJob) {
        super(autosysJob);
    }

    @Override
    public void convert() {
        super.convert();
        this.addFileTransferAutoedits();
        this.addConnectionProfile();
        this.addMessage();
    }

    private void addMessage() {
        this.autosysJob.addMessage("WRN4062", this.autosysJob.getOriginalJobName(), this.autosysJob.getJobName(), this.getConnectionProfile());
    }

    private void addFileTransferAutoedits() {
        this.checkAndInsertAutoedit("%%FTP-TYPE1", "I");
        String direction = this.getDirection("scp_transfer_direction");
        this.checkAndInsertAutoedit("%%FTP-UPLOAD1", direction);
        this.checkAndInsertAutoedit("%%FTP-LPATH1", this.getLocalName());
        this.checkAndInsertAutoedit("%%FTP-RPATH1", this.getRemotePath());
    }

    private String getLocalName() {
        return this.removeUnneededSlashesFromPath(this.removeFirstAndLastQuote(this.sourceAttr.getAttr("scp_local_name")));
    }

    private String removeUnneededSlashesFromPath(String input) {
        return input.replace("\\\\", "\\");
    }

    private String removeFirstAndLastQuote(String input) {
        return GlobalFunctions.removeQuotesIfNeeded((String)input);
    }

    private Optional<String> getAttr(String attr) {
        return Optional.ofNullable(this.sourceAttr.getAttr(attr)).filter(x -> !x.equals("NULL"));
    }

    private String getRemotePath() {
        Optional<String> remoteDir = this.getAttr("scp_remote_dir").map(this::removeFirstAndLastQuote);
        Optional<String> remoteName = this.getAttr("scp_remote_name").map(this::removeFirstAndLastQuote);
        return this.removeUnneededSlashesFromPath(this.concatWithSlash(remoteDir.orElse(""), remoteName.orElse("")));
    }

    private String concatWithSlash(String left, String right) {
        String slash = this.isTargetOsWindows() ? "\\" : "/";
        boolean leftHasSlash = left.isBlank() || left.endsWith(slash);
        boolean rightHasSlash = right.startsWith(slash);
        if (leftHasSlash || rightHasSlash) {
            return left + right;
        }
        return left + slash + right;
    }

    private void addConnectionProfile() {
        String connectionProfile = this.getConnectionProfile();
        this.autoedits.put("%%FTP-ACCOUNT", connectionProfile);
    }

    private String getConnectionProfile() {
        Object connectionProfile = "DEF_CON_PROFILE";
        String scpLocalUser = this.sourceAttr.getAttr("scp_local_user");
        String scpServerName = this.sourceAttr.getAttr("scp_server_name");
        if (!scpLocalUser.equals("NULL") && !scpServerName.equals("NULL")) {
            connectionProfile = "SCP_" + this.converteToLegalCP(scpLocalUser, scpServerName);
        }
        return connectionProfile;
    }

    private boolean isTargetOsWindows() {
        String targetOs = Optional.ofNullable(this.sourceAttr.getAttr("scp_target_os")).orElse("UNIX");
        return targetOs.equalsIgnoreCase("Windows");
    }
}

