/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.oozie;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OozieProperties {
    private File propertiesFile;
    private Properties originalProperties;
    private Properties resolvedProperties;
    private Properties annotatedProperties;
    private ArrayList<String> propertiesOrder;
    private Pattern variablePattern = Pattern.compile("\\$\\{(.*?)\\}");

    public OozieProperties(String propertiesFilePath) throws FileNotFoundException, IOException {
        this.originalProperties = new Properties();
        this.resolvedProperties = new Properties();
        this.annotatedProperties = new Properties();
        this.propertiesOrder = new ArrayList();
        if (propertiesFilePath != null) {
            this.propertiesFile = new File(propertiesFilePath);
            if (this.propertiesFile.exists()) {
                this.load();
            }
        }
    }

    public OozieProperties(String propertiesFilePath, OozieProperties parentProperties) throws FileNotFoundException, IOException {
        this.originalProperties = new Properties(parentProperties.originalProperties);
        this.resolvedProperties = new Properties(parentProperties.resolvedProperties);
        this.annotatedProperties = new Properties(parentProperties.annotatedProperties);
        this.propertiesOrder = new ArrayList();
        if (propertiesFilePath != null) {
            this.propertiesFile = new File(propertiesFilePath);
        }
        if (this.propertiesFile != null && this.propertiesFile.exists()) {
            this.load();
        } else {
            this.propertiesOrder = new ArrayList<String>(parentProperties.propertiesOrder);
        }
    }

    public String getProperty(String key) {
        return this.originalProperties.getProperty(key);
    }

    public String getResolvedProperty(String key) {
        return this.resolvedProperties.getProperty(key);
    }

    public String getAnnotatedProperty(String key) {
        return this.annotatedProperties.getProperty(key);
    }

    public ArrayList<String> getPropertiesOrder() {
        return this.propertiesOrder;
    }

    public String resolveString(String str) {
        if (str != null) {
            Matcher matcher = this.variablePattern.matcher(str);
            while (matcher.find()) {
                if (this.resolvedProperties.getProperty(matcher.group(1)) == null) continue;
                str = str.replace(matcher.group(0), this.resolvedProperties.getProperty(matcher.group(1)));
            }
        }
        return str;
    }

    public String annotateString(String str) {
        if (str != null) {
            Matcher matcher = this.variablePattern.matcher(str);
            while (matcher.find()) {
                if (matcher.group(0).equals(str)) {
                    str = str.replace(matcher.group(0), "%%" + matcher.group(1));
                    continue;
                }
                str = str.replace(matcher.group(0), "%%" + matcher.group(1) + ".");
            }
        }
        return str;
    }

    private void load() throws IOException {
        try (FileReader reader = new FileReader(this.propertiesFile);){
            this.originalProperties.load(reader);
        }
        for (String property : this.originalProperties.stringPropertyNames()) {
            this.setAnnotatedProperties(property, this.originalProperties.getProperty(property));
            this.setResolvedProperties(property, this.originalProperties.getProperty(property));
        }
    }

    private void setAnnotatedProperties(String key, String value) {
        Matcher matcher = this.variablePattern.matcher(value);
        while (matcher.find()) {
            value = value.replace(matcher.group(0), "%%" + matcher.group(1));
        }
        this.annotatedProperties.setProperty(key, value);
    }

    private String setResolvedProperties(String key, String value) {
        if (!this.resolvedProperties.contains(key)) {
            Matcher matcher = this.variablePattern.matcher(value);
            while (matcher.find()) {
                String newKey = matcher.group(1);
                String newKeyValue = matcher.group(0);
                if (this.resolvedProperties.contains(newKey)) {
                    newKeyValue = this.resolvedProperties.getProperty(newKey);
                } else if (this.originalProperties.containsKey(newKey)) {
                    newKeyValue = this.setResolvedProperties(newKey, this.originalProperties.getProperty(newKey));
                }
                value = value.replace(matcher.group(0), newKeyValue);
            }
            if (!this.propertiesOrder.contains(key)) {
                this.propertiesOrder.add(key);
            }
            this.resolvedProperties.setProperty(key, value);
        }
        return value;
    }
}

